# -*- coding: UTF-8 -*-
import re
import common
import hardware

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 控制器状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    controllerID = ""
    operationStatus = ""
    healthStatus = ""
    #获取首个不为空的BOM编码值
    standardBomCode = ""
    cliRet = cli.execCmd("showcontroller")
    if not re.search("Controller Information", cliRet, re.IGNORECASE):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取控制器信息无效。"
        else:
            errMsg = "\nController information invalid."
        return (False, cliRet, errMsg)
    
	
	#TV1系列只有双控场景 
    for id in ["A","B"]:
        bomCode = hardware.getHardwareBomCode([id], "CTRL", cliRet)
        if bomCode:
            standardBomCode = bomCode
            break
			
    list = cliRet.splitlines()		
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
            
        elif field.startswith("OperationStatus"):
            operationStatus = field.replace("OperationStatus", "")
            if "Normal" != operationStatus:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（控制器ID：" + controllerID + u"）的操作状态存在异常（" + operationStatus + u"）。"
                    if standardBomCode:
                        errMsg += u"\n硬件（控制器ID：" + controllerID + u"）的BOM编码（" + standardBomCode + u"）。"
                    else:
                        errMsg += u"\n无法获取硬件（控制器ID：" + controllerID + u"）的BOM编码。" 
                        
                else:
                    errMsg += "\nThe operation status of controller (controller-id:" + controllerID\
                              + ") is abnormal(" + operationStatus + ")."
                    if standardBomCode:
                        errMsg += u"\nBOM number of hardware(Controller ID:" + controllerID + u"):" + standardBomCode + u"."
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(Controller ID:" + controllerID + u") ." 
        elif field.startswith("HealthStatus"):
            healthStatus = field.replace("HealthStatus", "")
            if "Normal" != healthStatus:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器（控制器ID：" + controllerID + u"）的健康状态存在异常（" + healthStatus + u"）。"
                    if standardBomCode:
                        errMsg += u"\n硬件（控制器ID：" + controllerID + u"）的BOM编码（" + standardBomCode + u"）。"
                    else:
                        errMsg += u"\n无法获取硬件（控制器ID：" + controllerID + u"）的BOM编码。" 
                     
                else:
                    errMsg += "\nThe health status of controller (controller-id:" + controllerID\
                              + ") is abnormal(" + healthStatus + ")."
                    if standardBomCode:
                        errMsg += u"\nBOM number of hardware(controller-id:" + controllerID + u"):" + standardBomCode + u"."
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(controller-id:" + controllerID + u")." 
						
    return (flag, cliRet, errMsg)