# -*- coding: UTF-8 -*-

import traceback
import common
import re
from comm import modelManager


def getPeerDiskNameAndUsage(cli,py_java_env,usrPwd):
    lang = py_java_env.get("lang")
    flag = True
    allRet = ""
    errMsg = ""
    peerNameDict = {}
    peerUsageDict = {}
#通过心跳登录对端设备
    enterFlag,result = modelManager.linkCtrlInMinisystem(cli,usrPwd)
    allRet += result
    if enterFlag == False:
        flag = False
        if lang == "zh":
            errMsg = u"\n登录对端设备失败。"
        else:
            errMsg = "\nFailed to log in to the peer-end device."
        return (flag, peerNameDict, peerUsageDict, allRet, errMsg)
    
    enterFlag = modelManager.changeCliModel2Minisystem(cli, py_java_env)
    if enterFlag == False:
        flag = False
        if lang == "zh":
            errMsg = u"\n进入minisystem模式失败。"
        else:
            errMsg = "\nFailed to log in to the device in minisystem mode."
        return (flag, peerNameDict, peerUsageDict, allRet, errMsg)
    #获取硬盘和盘符的对应关系
    finishStrList = ["> "]
    nameRet = cli.execCmd("showdiskinfo",finishStrList)
    allRet += nameRet
    retList = nameRet.splitlines()
    if len(retList) < 9 or re.search("MML>dev",nameRet,re.IGNORECASE) == None:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(nameRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."
            return (flag, peerNameDict, peerUsageDict, allRet, errMsg)
    peerNameDict = common.getDiskNameInfo(nameRet)

    #获取对端硬盘对应的利用率信息，回文中每两秒打印一次数据，判断利用率时，丢掉第一次数据（因为第一次数据不准确），获取后面30次数据来进行判断
    usageRet = cli.execCmdWithTimout("iostat -x 2 -N 31", 300)
    allRet += usageRet
    if re.search("Device:",usageRet,re.IGNORECASE) == None:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(usageRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."
            return (flag, peerNameDict, peerUsageDict, allRet, errMsg)
    peerUsageDict = common.getUsageInfoByName(usageRet,peerNameDict.values())
    return (flag, peerNameDict, peerUsageDict, allRet, errMsg)

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 硬盘利用率检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** #
def execute(cli):
    """
        1 如果当前系统软件版本在V100R005C00SPC700及之后，则继续执行以下步骤；否则检查结果为不涉及；
        2 每个控制器上每2秒收集一次硬盘利用率，持续观察1分钟，满足以下条件：
         1）存在一端控制器上10次的利用率超过阈值（SATA/NL-SAS盘60%、SAS/FC盘80%）的盘，则检查结果为不通过。
         2）存在一端控制器上10次的利用率超过阈值（SATA/NL-SAS盘40%、SAS/FC盘60%）的盘，则检查结果为建议优化。
         3）其他情况，检查结果为通过。
        3 命令执行失败，检查结果为不通过。
        （备注：iostat -x 2 -N 31命令执行结果中，%utils列代表各硬盘的利用率）
    """
    flag = True
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    sftp = py_java_env.get("sftp")
    errMsg = ""
    allRet = ""
    try:
        systemFlag,systemInfoStr = common.isSystemNormal(cli, lang)
        allRet += systemInfoStr
        flag, sysSpcVersion, cliRet, errMsg= common.getCurSystemVersion(cli,lang)
        if flag == False or sysSpcVersion == "":
            return (flag, cliRet, errMsg)
        allRet +=  cliRet
        
        common.refreshProcess(py_java_env, 2, logger)
        #V100R005C00SPC700之前版本不涉及，V100R005C00和V100R005C01属于同一个级别，V100R005C01SPC700版本之前为不涉及
        if sysSpcVersion < "V100R005C00SPC700" or ("V100R005C01" in sysSpcVersion and sysSpcVersion < "V100R005C01SPC700"):
            flag = "NOSUPPORT"
            return (flag, allRet, errMsg)
        common.refreshProcess(py_java_env, 5, logger)
        devNode = py_java_env.get("devInfo")
        currentIP = devNode.getIp()
        usrPwd = devNode.getLoginUser().getPassword()
        
    
        failNum = 0
        warnNum = 0
        failFlag = False
        warnFlag = False
        cliRet = cli.execCmd("showctrlip")
        retList = cliRet.splitlines()
        if len(retList) < 7:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(cliRet, True):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCli信息无效。"
                else:
                    errMsg = "\nInvalid Cli information."
            return (flag, cliRet, errMsg)
        common.refreshProcess(py_java_env, 8, logger)
        localCtrlID = 'A'
        peerCtrlID = 'B'
        for line in retList:
            if  re.search(currentIP,line,re.IGNORECASE):
                localCtrlID = line.split()[0]
                if localCtrlID == 'B':
                    peerCtrlID = 'A'
                    break
        allRet += cliRet
        common.refreshProcess(py_java_env, 10, logger)
        cliRet = cli.execCmd("showdisk -physic")
        list = cliRet.splitlines()
        if len(list) < 7:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(cliRet, True):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCli信息无效。"
                else:
                    errMsg = "\nInvalid Cli information."
            return (flag, cliRet, errMsg)
        allRet +=cliRet
        common.refreshProcess(py_java_env, 15, logger)
        #获取系统硬盘以及对应的硬盘的字典类型
        typeDict = common.getDiskTypeInfo(cliRet)
        logger.info("typeDict:" + str(typeDict))
        enterFlag = modelManager.changeCliModel2Minisystem(cli, py_java_env)
        if enterFlag == False:
            flag = False
            if lang == "zh":
                errMsg = u"\n进入minisystem模式失败。"
            else:
                errMsg = "\nFailed to log in to the device in minisystem mode."
            return (flag, allRet, errMsg)
        common.refreshProcess(py_java_env, 20, logger)
        #获取硬盘和盘符的对应关系
        finishStrList = ["> "]
        nameRet = cli.execCmd("showdiskinfo",finishStrList)
        allRet += nameRet
        retList = nameRet.splitlines()
        if len(retList) < 9 or re.search("MML>dev",nameRet,re.IGNORECASE) == None:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(nameRet, True):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCli信息无效。"
                else:
                    errMsg = "\nInvalid Cli information."
            return (flag, allRet, errMsg)
        common.refreshProcess(py_java_env, 25, logger)
        nameDict = common.getDiskNameInfo(nameRet)
        logger.info("nameDict:" + str(nameDict))
        #获取硬盘对应的利用率信息，回文中每两秒打印一次数据，
        #判断利用率时，丢掉第一次数据（因为第一次数据不准确），获取后面30次数据来进行判断
        usageRet = cli.execCmdWithTimout("iostat -x 2 -N 31", 300)
        allRet += usageRet
        if re.search("Device:",usageRet,re.IGNORECASE) == None:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(usageRet, True):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCli信息无效。"
                else:
                    errMsg = "\nInvalid Cli information."
            return (flag, allRet, errMsg)
        common.refreshProcess(py_java_env, 40, logger)
        localUsageDict = common.getUsageInfoByName(usageRet,nameDict.values())
        logger.info("localUsageDict:" + str(localUsageDict))
        common.refreshProcess(py_java_env, 50, logger)
        peerCheckFlag = True
        peerNameDict = {}
        peerUsageDict = {}
        if systemFlag:
            (peerCheckFlag, peerNameDict, peerUsageDict, peerRet, errInfo) = getPeerDiskNameAndUsage(cli,py_java_env,usrPwd)
            allRet += peerRet
            errMsg += errInfo
        logger.info("peerNameDict:" + str(peerNameDict))    
        logger.info("peerUsageDict:" + str(peerUsageDict))
        locationList = typeDict.keys()
        locationList.sort()
        logger.info("locationList:" + str(locationList))
        common.refreshProcess(py_java_env, 70, logger)
         
        currentProcess = 71
        singleLunProcess = 25
        if len(locationList) > 0:
            singleLunProcess = 25.0/len(locationList)
        
        nodeProcess = singleLunProcess
        
        for locate in locationList:
            localUsageNum = 0
            peerUsageNum = 0
            localUsageList = []
            peerUsageList = []
            ctrlIDList = []
            type = typeDict.get(locate)
            if type in ["SATA","NL SAS"]:
                failNum = 60.0
                warnNum = 40.0
            elif type in ["SAS","FC"]:
                failNum = 80.0
                warnNum = 60.0
            
            localUsageList = localUsageDict.get(nameDict.get(locate))
            if localUsageList != None and len(localUsageList) > 10:
                localUsageList.sort()
                localUsageNum = localUsageList[-10]
            if systemFlag and peerCheckFlag:
                peerUsageList = peerUsageDict.get(peerNameDict.get(locate,""))
                if peerUsageList != None and len(peerUsageList) > 10:
                    peerUsageList.sort()
                    peerUsageNum = peerUsageList[-10]
                logger.info("peerUsageList:" + str(peerUsageList))
            logger.info("locate:" + locate)
            logger.info("type:" + type)
            logger.info("diskName:" + nameDict.get(locate,""))
            logger.info("localUsageList:" + str(localUsageList))

            #本端的硬盘的利用率检查
            if localUsageNum > failNum:
                failFlag = True
                ctrlIDList.append(localCtrlID)
            elif localUsageNum > warnNum:
                warnFlag = True
                ctrlIDList.append(localCtrlID)
            if systemFlag and peerCheckFlag:
                #对端的硬盘的利用率检查
               
                if peerUsageNum > failNum:
                    ctrlIDList.append(peerCtrlID)
                    failFlag = True
                elif peerUsageNum > warnNum:
                    ctrlIDList.append(peerCtrlID)
                    warnFlag = True
            if nodeProcess > 1:
                currentProcess += int(nodeProcess)
                nodeProcess = singleLunProcess
                common.refreshProcess(py_java_env, currentProcess, logger)
            else:
                nodeProcess += singleLunProcess
            locateList = locate.replace("(","").replace(")","").split(",")
            for ctrlId in ctrlIDList:
                if lang == "zh":
                    errMsg +=u"\n硬盘(框号:"+ locateList[0] + u",槽位号:" + locateList[1] + u",控制器:" + ctrlId + u")的IO利用率超过阈值。"
                else:
                    errMsg +="\nThe I/O usage of disks (enclosure ID:"+ locateList[0] + ",slot ID:" + locateList[1] + ",controller:" + ctrlId + ")exceeds the threshold."
        if peerCheckFlag == False or failFlag:
            flag = False
        elif warnFlag:
            flag ="WARNING"
        return (flag, allRet, errMsg)
    except Exception, exception:
        logger.error("traceback:" + str(traceback.format_exc()))
        return (False, allRet, errMsg)
    finally:
        modelManager.changeAnyModel2Cli(cli,sftp)
        common.refreshProcess(py_java_env, 100, logger)
    