# -*- coding: UTF-8 -*-

import common
import traceback
import hardware

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 硬盘固件版本检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    硬盘的固件版本检查
    1 如果硬盘的检查标准满足以下条件之一，则检查结果为建议优化。
     1） Model为HUS156060VLS600，且Firmware Version为A510,A760其中之一；
     2） Model为HUS156060VLF400，且Firmware Version为fT02,F510其中之一；
    """
    
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""
    bugDiskIDList = []
    #存在问题的固件Model与对应的FW
    bugFWVersionMap = {
                       "HUS156060VLS600":("A510","A760"),
                       "HUS156060VLF400":("FT02","F510"),
                       }

    #存放无法获取固件版本值的硬盘
    errInfoDiskIDList = []  
    try:
        cliRet = cli.execCmd("showdisk -physic")
        lines = cliRet.splitlines()
        if len(lines) < 7:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(cliRet, True):
                flag = False
                errMsg = common.getMsg(lang, "invalid.cli.information")     
            return (flag, cliRet, errMsg)

        diskDict = hardware.getHorizontalCliRet("DISK",cliRet)
        diskIDList = diskDict.get("Disk Location","")
        modelList = diskDict.get("Model","")
        FWVersionList = diskDict.get("FW Version","")
        if diskIDList and modelList and FWVersionList:
            for (diskId, model, FWVersion) in zip(diskIDList, modelList, FWVersionList):
                bugVersionList = bugFWVersionMap.get(model)
                if FWVersion == "" or FWVersion == "--":
                    errInfoDiskIDList.append(diskId)
                    continue
                if not bugVersionList: 
                    continue
                if FWVersion.upper() in bugVersionList:
                    bugDiskIDList.append(diskId)

        if bugDiskIDList:
            flag = common.RESULT_WARNING
            errMsg = common.getMsg(lang, "low.fmversion.disk.info",", ".join(bugDiskIDList))
        if errInfoDiskIDList:
            flag = False
            errMsg += common.getMsg(lang, "canot.get.fmversion.disk.info",", ".join(errInfoDiskIDList))

        return (flag, cliRet, errMsg)

    except Exception:
        errMsg = common.getMsg(lang, "query.result.abnormal") 
        PY_LOGGER.error("Inspect[DiskFWVersion] catch except of trace back:" + str(traceback.format_exc()))
        return (False, cliRet, errMsg)