# -*- coding: UTF-8 -*-

"""P11G-5580 框状态查询巡检项增加 20121204 added Begin"""
import re 
import common
import hardware

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 框状态
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showenclosure")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."           
        return (flag, cliRet, errMsg)
    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        if "Online" != list2[2]:
            flag = False
			#获取指定硬件ID的BOM编码
            bomCode = hardware.getHardwareBomCode([list2[0]],"ENCLOSURE",cliRet)
            if "zh" == lang:
                errMsg += u"\n框（框ID：" + list2[0] + u"）的状态存在异常（" + list2[2] + u"）。"
                if bomCode:
                    errMsg += u"\n硬件（框ID：" + list2[0] + u"）的BOM编码（" + bomCode + u"）。" 
                else:
                    errMsg += u"\n无法获取硬件（框ID：" + list2[0] + u"）的BOM编码。"  
            else:
                errMsg += "\nThe status of enclosure (enclosure-id:" + list2[0] \
                          + ") is abnormal(" + list2[2] + ")."
                if bomCode:
                    errMsg += u"\nBOM number of hardware(enclosure-id:" + list2[0] + u"):" + bomCode + u"." 
                else:
                    errMsg += u"\nCannot obtain the BOM number of the hardware(enclosure-id:" + list2[0] + u")." 

    return (flag, cliRet, errMsg)

"""P11G-5580 框状态查询巡检项增加 20121204 added End"""
