# -*- coding: UTF-8 -*-
import re 
import common
import hardware

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 级联模块状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    controllerID = ""
    enclosureID = ""
    status = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showexpmodule")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."
        return (flag, cliRet, errMsg)  
	#用于存放硬件BOM编码值
    bomCode = "" 
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        if field.startswith("ControllerID"):
            controllerID = field.replace("ControllerID", "")
        elif field.startswith("EnclosureID"):
            enclosureID = field.replace("EnclosureID", "")
			#获取指定硬件ID的BOM编码
            bomCode = hardware.getHardwareBomCode([controllerID,enclosureID],"EXP",cliRet)
        elif field.startswith("Status"):
            status = field.replace("Status", "")
            if status != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n框（ID：" + enclosureID + u"）的级联模块（ID：" + controllerID + u"）状态异常（" + status + u"）。"
                    if bomCode:
                        errMsg += u"\n硬件（控制器ID：" + controllerID + u" 框ID：" + enclosureID\
                                      + u"）的BOM编码（" + bomCode + u"）。" 
                    else:
                        errMsg += u"\n无法获取硬件（控制器ID：" + controllerID + u" 框ID：" + enclosureID\
                                      + u"）的BOM编码。"  
                else:
                    errMsg += ("\nThe status of expansion module(ID:" + controllerID + u") in the enclosure(ID:" 
                              + enclosureID + ") is abnormal(" + status + ").")
                    if bomCode:
                        errMsg += u"\nBOM number of hardware(controller-id:" + controllerID + u", enclosure-id:" + enclosureID\
                                      + u"):" + bomCode + u"." 
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(controller-id:" + controllerID + u", enclosure-id:" + enclosureID + u")." 

    return (flag, cliRet, errMsg)