# -*- coding: UTF-8 -*-
import re
import traceback
import common
from common import getCurSystemVersion
from comm import modelManager
from comm.cTV1R1 import parseHorizontal
from comm.cTV1R1 import ParseException
from common import getParseExceptErrMsg

def execute(cli):
    """
    Create date        : 2015/03/24
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    errMsg = ""
    cliRet = ""
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    
    flag, sysSpcVersion, cliRet1, errMsg = getCurSystemVersion(cli, lang)
    cliRet += cliRet1
    if not flag:
        return (flag, cliRet, errMsg)
    
    if sysSpcVersion not in ("V100R002C00SPC015", "V100R002C00SPCg00", "V100R005C00SPC500"):
        return (True, cliRet, errMsg)
    
    cliRet2 = cli.execCmd("showport")
    cliRet += "\n" + cliRet2

    #判断cli信息是否有效
    if not common.checkCliInfoValid(cliRet, False):
        flag = False
        if lang == "zh":
            errMsg = u"\n获取端口信息无效。"
        else:
            errMsg = "\nGet port information invalid."
        return (flag, cliRet, errMsg)
    
    try:
        portInfoDictList = parseHorizontal(cliRet2).getResult()
    except ParseException, e:
        logger.error("[FCModuleException]get trace back: " + unicode(traceback.format_exc()))
        return False, cliRet, getParseExceptErrMsg(lang)
    
    for portInfoDict in portInfoDictList:
        if portInfoDict.get("Physical Type", "").upper() == "FC":
            logger.warn("[FCModuleException]exist FC Port.")
            if "zh" == lang:
                errMsg += u"\n存在前端FC接口卡的设备，如果发生异常掉电，会低概率出现RAID组故障。"
            else:
                errMsg += "\nIf devices configured with front-end FC interface cards are powered off unexpectedly, there is a low probability that a RAID group fault occurs."
            return ("WARNING", cliRet, errMsg)
    else:
        return (True, cliRet, errMsg)                 
