# -*- coding: UTF-8 -*-

"""P11G-5580 FC链路速率 20121204 added Begin"""
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: FC链路速率巡检
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """admin:/>showfcspeed
    ============================================================================================================
                                                   FC Port Speed
    ------------------------------------------------------------------------------------------------------------
      Controller ID    Interface Module ID    Port ID    WWN                 Current Speed    Configured Speed  
    ------------------------------------------------------------------------------------------------------------
      A                0                      P0         20000022a10b6c5c    8Gbps            --                
      A                0                      P1         20010022a10b6c5c    --               --                               
      B                0                      P2         20120022a10b6c5c    --               --                
      B                0                      P3         20130022a10b6c5c    --               --                
    ============================================================================================================
    """"""
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    curspeedtemp = ""
    confspeedtemp = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showfcspeed")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."            
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 6:
            continue
        
        curspeedtemp = list2[4]
        confspeedtemp = list2[5]
        
        if curspeedtemp not in ("--", "AUTO", "1Gbps" , "2Gbps" ,"4Gbps" ,"8Gbps" )\
            or confspeedtemp not in ("--", "AUTO", "1Gbps" , "2Gbps" ,"4Gbps" ,"8Gbps" ):

            flag = False
            if "zh" == lang:
                errMsg += u"\nFC端口（控制器ID：" + list2[0] + u"，接口模块ID：" + list2[1] + u"，端口ID：" + list2[2] \
                            + u"）的速度存在异常（" + u"当前速度为：" + curspeedtemp + u"，配置速度为：" + confspeedtemp + u"）。"
                   
            else:
                errMsg += "\nThe FC port (controller-id:" + list2[0] + ", interface-module-id:" + list2[1] + ", port-id:"\
                            + list2[2] + ") is abnormal (" + "current-speed:" + curspeedtemp + u", configured-speed:" + confspeedtemp + ")."

    return (flag, cliRet, errMsg)

"""P11G-5580 FC链路速率 20121204 added End"""