# -*- coding: UTF-8 -*-
import common
import hardware

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 光模块状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showfibremodule")

    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."        
        return (flag, cliRet, errMsg)
    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 7:
            continue
        #获取指定硬件ID的BOM编码
        bomCode = hardware.getHardwareBomCode([list2[0],list2[1],list2[4],list2[5]],"FIBRE",cliRet)
        if "Normal" not in list2:
            flag = False
            if "zh" == lang:
                errMsg += u"\nFC端口（框ID：" + list2[1] + u"，控制器ID：" + list2[0] + u"，接口模块ID：" \
                            + list2[4] + u"，端口ID：" + list2[5] + u"）的状态存在异常。"
                if bomCode:
                    errMsg += u"\n硬件（框ID：" + list2[1] + u"，控制器ID：" + list2[0] + u"，接口模块ID：" \
                            + list2[4] + u"，端口ID：" + list2[5] + u"）的BOM编码（" + bomCode + u"）。" 
                else:
                    errMsg += u"\n无法获取硬件（框ID：" + list2[1] + u"，控制器ID：" + list2[0] + u"，接口模块ID：" \
                            + list2[4] + u"，端口ID：" + list2[5] + u"）的BOM编码。" 
            else:
                errMsg += "\nThe optical transceiver status of port (enclosure-id:" + list2[1] \
                            + ", controller-id:" + list2[0] + ", interface-module-id:" + list2[4] \
                            + ", port-id:" + list2[5] + ") is abnormal."
                if bomCode: 
                               
                    errMsg += u"\nBOM number of hardware(enclosure-id:" + list2[1] \
                            + ", controller-id:" + list2[0] + ", interface-module-id:" + list2[4] \
                            + ", port-id:" + list2[5] + "):" + bomCode + u"." 
                else:
                    errMsg += u"\nCannot obtain the BOM number of the hardware(enclosure-id:" + list2[1] \
                            + ", controller-id:" + list2[0] + ", interface-module-id:" + list2[4] \
                            + ", port-id:" + list2[5] + ")." 

    return (flag, cliRet, errMsg)