# -*- coding: UTF-8 -*-
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 热补丁版本一致性检查
# 输入参数: dataDict
# **************************************************************************** # 
def execute(cli):
    
    cliRet = ""
    errMsg = ""

    lang = py_java_env.get("lang")
    
    #获取Cli信息
    systemInfoStr = cli.execCmd("showsys")
    hotPatchInfoStr = cli.execCmd("showupgradepkginfo -t 3")
    cliRet = systemInfoStr + "\n" + hotPatchInfoStr
    
    #判断回文是正确
    if not re.search("System Name", systemInfoStr, re.IGNORECASE):
        if lang == "zh":
            errMsg = u"\n获取系统信息失败。"
        else:
            errMsg = "\nGetting system information failed."
        return (False, cliRet, errMsg)

    #单控设备直接检查通过
    if re.search("Single Controller", systemInfoStr, re.IGNORECASE):
        return (True, cliRet, '')

    #不支持热补丁，检查通过
    if re.search("not exist.|Error : Invalid argument", hotPatchInfoStr, re.IGNORECASE):
        return (True, cliRet, '')

    #没有安装任何热补丁，检查通过
    if re.search("command operates successfully", hotPatchInfoStr, re.IGNORECASE):
        return (True, cliRet, '')
    
    lineList = hotPatchInfoStr.splitlines()
    #信息少于7行，查询信息失败
    if len(lineList) < 7:
        if lang == "zh":
            errMsg = u"\n获取热补丁信息失败。"
        else:
            errMsg = "\nGetting hot patch information failed."
        return (False, cliRet, errMsg)
    
    #导入了热补丁包但是没有激活
    if not re.search("Running", hotPatchInfoStr, re.IGNORECASE):
        return (True, cliRet, '')

    #查询所有热补丁版本号
    hotPatchVerList = []
    for line in lineList:
        if re.search("A|B", line) and re.search("Running", line, re.IGNORECASE):
            field = line.split()
            if len(field) >= 2:
                hotPatchVerList.append(field[1])
        else:
            continue

    #只有一端有补丁，或者两端控制器都有补丁但是版本号不相同，则报检查不通过
    ctrlCounter = len(hotPatchVerList)
    if ctrlCounter == 0 or ctrlCounter > 2:
        if lang == "zh":
            errMsg = u"\n获取热补丁版本号失败。"
        else:
            errMsg = "\nGetting hot patch version failed."
        return (False, cliRet, errMsg)  
    elif ctrlCounter == 1:
        #双控设备，只有一端加载热补丁,报错
        if lang == "zh":
            errMsg = u"\n只有一端控制器加载热补丁成功。"
        else:
            errMsg = "\nOnly one controller loaded the hot patch successfully."
        return (False, cliRet, errMsg)
    elif ctrlCounter == 2 and hotPatchVerList[0] != hotPatchVerList[1]:
        if lang == "zh":
            errMsg = u"\n两端控制器的热补丁版本号不相同。"
        else:
            errMsg = "\nThe hot patch versions of two controllers are not the same."
        return (False, cliRet, errMsg) 

    #检查结果返回
    return (True, cliRet, "")
