# -*- coding: UTF-8 -*-
import common
from config import TV1_MODEL_VER_PATCH_LIST
import os
import java.lang.System as javaSystem
import traceback
from defusedxml import ElementTree as ET

def execute(cli):
    '''
            热补丁推荐版本检查
    1、如果产品型号或者系统软件版本不在检查范围内，或者系统已安装推荐版本的热补丁，则检查通过。
    2、如果系统未安装热补丁或热补丁版本低于推荐版本则检查结果为建议优化。
    '''
    cliRet = ""
    try:
        lang = py_java_env.get("lang")
        logger = PY_LOGGER
        patchWarningDevs = common.getPatchWarningDevs(py_java_env)
        #获取设备型号
        isQryOk, deviceType, cliRet, errMsg = common.getDeviceType(cli, lang)
        if not isQryOk:
            return (False, cliRet, errMsg)
        
        #获取设备当前产品版本
        isQryOk, sysSpcVer, sysVerRet, errMsg = common.getCurSystemVersion(cli, lang)
        cliRet += sysVerRet
        if not isQryOk:
            return (False, cliRet, errMsg)
        
        #获取补丁信息
        isQryOk, curHotPatchVer, hotPatchVerRet, errMsg = common.getCurHotPatchVersion(cli, lang)
        cliRet += hotPatchVerRet
        if not isQryOk:
            return (False, cliRet, errMsg)
     
        #判断当前设备是否为风险版本
        isQryOk ,needHotPatchVer,patchName,carrierpatchPach,EnterprisepatchPach, isLinkageAvaliable = checkRiskVersion(deviceType,sysSpcVer,curHotPatchVer,lang,logger)
        
        if isQryOk == common.RESULT_NOCHECK:
            errMsg = common.getMsg(lang, "parse.product.hotpatch.file.filed")
            return (isQryOk, cliRet ,errMsg)
        
        if not isQryOk:
            #判断是否存在本地补丁
            patchSavePath = javaSystem.getenv("patchSavePath")
            if patchSavePath != None and os.path.exists(patchSavePath + os.sep + patchName):
                errMsg = common.getMsg(lang, "exist.hotpatch.error.mseeages",(deviceType,sysSpcVer,needHotPatchVer,(patchSavePath + os.sep + patchName)))
                #interact interface :this diction's key is not changeable 
                if not "FALSE" == isLinkageAvaliable.strip().upper() :
                    patchBasisDict = {"hotPatchPath" : str(os.path.join(patchSavePath, patchName)),
                                      "curPatchVersion" : curHotPatchVer,
                                      "suggestPatchVersion" : needHotPatchVer}
                    patchWarningDevs.put(common.getCurDeviceInfo(py_java_env), patchBasisDict)
            else:
                #补丁路径不存在或者补丁不存在
                supportPath = ""
                if carrierpatchPach:
                    supportPath += common.getMsg(lang, "carrierpatchPach",(carrierpatchPach))
                if EnterprisepatchPach:
                    supportPath += common.getMsg(lang, "EnterprisepatchPach",(EnterprisepatchPach))
                errMsg = common.getMsg(lang, "not.exist.hotpatch.error.mseeages",(deviceType,sysSpcVer,needHotPatchVer,supportPath))
        
            return (common.RESULT_WARNING, cliRet, errMsg)
            
        return (isQryOk, cliRet, errMsg)
    except:
        logger.error("check_item_HotPatchVersion failed, Exception:" + traceback.format_exc())
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))


def checkRiskVersion(deviceType,sysSpcVer,curHotPatchVer,lang,logger):
    '''
    @summary: 检查当前设备是否为风险版本
    @param deviceType: 设备型号
    @param sysVerRet: 产品版本
    @param curHotPatchVer: 当前热补丁版本
    @param needHotPatchVer: 目标热补丁版本
    @param logger: 日志对象
    @param lang: 语言
    @return:
        flag:
            True: 无风险版本
            False: 风险版本
    '''
    flag = True
    needHotPatchVer = ""
    patchName = ""
    carrierpatchPach = ""
    EnterprisepatchPach = ""
    linkageAvaliable = ""
    hotPatchNotExists = ["","--"]
    if javaSystem.getenv("patchSavePath") != None and \
            os.path.exists(javaSystem.getenv("patchSavePath") + os.sep + "productHotPatch.xml"):
        
        hotPatchVersionFilePath = javaSystem.getenv("patchSavePath") + os.sep + "productHotPatch.xml"
        hotPatchVersionDictList = parseXMLFile(hotPatchVersionFilePath,logger)
        if hotPatchVersionDictList == []:
            #解析补丁配套关系表失败，返回“未检查”
            flag = common.RESULT_NOCHECK
            return flag ,needHotPatchVer,patchName,carrierpatchPach,EnterprisepatchPach, linkageAvaliable
        
        for infoDict in hotPatchVersionDictList:
            versionList = infoDict.get("productVersion","").split(",")
            needHotPatchVer = infoDict.get("patchVersion","")
            downloadUrlUser = infoDict.get("downloadUrl-user","")
            flag, patchName, carrierpatchPach, EnterprisepatchPach, linkageAvaliable = \
            getRiskVersionSupportPath(lang,downloadUrlUser,deviceType,sysSpcVer,versionList,curHotPatchVer,hotPatchNotExists,needHotPatchVer)
            if not flag:
                break
            
    else:    
        for infoDict in TV1_MODEL_VER_PATCH_LIST:
            deviceTypeList = infoDict.get("modelList","")
            versionList = infoDict.get("versionList","")
            needHotPatchVer = infoDict.get("patchVersion","")
            
            if ((deviceType in deviceTypeList) and (sysSpcVer in versionList) and 
                    (curHotPatchVer in hotPatchNotExists or curHotPatchVer < needHotPatchVer)):
                patchName = infoDict.get("patchName","")
                #运营商补丁路径
                carrierpatchPach = infoDict.get("carrierpatchPach",{}).get(lang,"")
                #企业网补丁路径
                EnterprisepatchPach = infoDict.get("EnterprisepatchPach",{}).get(lang,"")
                flag = False
                break
            
    return flag, needHotPatchVer, patchName, carrierpatchPach, EnterprisepatchPach, linkageAvaliable

def getRiskVersionSupportPath(lang,downloadUrlUser,deviceType,sysSpcVer,versionList,\
                              curHotPatchVer,hotPatchNotExists,needHotPatchVer):
    '''
    @summary: 获取风险版本的Support补丁下载路径
    @param downloadUrlUser: 补丁路径字典列表
    @return:
        flag:
            True: 非风险版本
            False: 风险版本
            patchName：补丁名称
            carrierpatchPach：运营商补丁获取网址
            EnterprisepatchPach：企业网补丁获取网址
    '''
    flag = True
    patchName = ""
    carrierpatchPach = ""
    EnterprisepatchPach = ""
    parseLinkageAvaliable = ""
    for productModePathDict in downloadUrlUser:
        deviceTypeList = productModePathDict.get("productMode","").split(",")
        #去掉空格
        deviceTypeList = [devType.strip() for devType in deviceTypeList]
        
        if ((deviceType in deviceTypeList) and (sysSpcVer in versionList) and 
            (curHotPatchVer in hotPatchNotExists or curHotPatchVer < needHotPatchVer)):
            flag = False
            patchName = productModePathDict.get("patchName","")
            parseLinkageAvaliable = productModePathDict.get("toPatchTool","")
            if lang =="zh":
                #运营商补丁路径
                carrierpatchPach = productModePathDict.get("carrierUrl-zh","")
                #企业网补丁路径
                EnterprisepatchPach = productModePathDict.get("enterpriseUrl-zh","")
            else:
                #运营商补丁路径
                carrierpatchPach = productModePathDict.get("carrierUrl-en","")
                #企业网补丁路径
                EnterprisepatchPach = productModePathDict.get("enterpriseUrl-en","")
                
            break
        
    return flag, patchName, carrierpatchPach, EnterprisepatchPach, parseLinkageAvaliable             

def parseXMLFile(filePath,logger):
    '''
    @summary: 解析xml的指定节点
    @param element: xml的一个节点
    @return: 解析后的xml节点信息（一个嵌套的字典列表)
    '''
    try:              
        hotPatchVersionDictList =[]
        xmlElementTree = ET.parse(filePath)
        rootElement = xmlElementTree.getroot()
        element = rootElement.getiterator(tag="patch")
        
        for child in element:
            #解析产品版本
            productVersion = child.getiterator(tag="productVersion")[0].text.strip()
            #解析补丁版本
            patchVersion = child.getiterator(tag="patchVersion")[0].text.strip()
            productPatchVersionDict = {"productVersion":productVersion,"patchVersion":patchVersion}
            
            #解析Support补丁下载路径和对应产品型号、补丁名称
            downloadUrluser = child.getiterator(tag="downloadUrl-user")
            downloadUrl = downloadUrluser[0].getiterator(tag="downloadUrl")
            
            supportPatchPathList = []
            for child in downloadUrl:
                modelPatchNameDict = child.attrib
                carrierUrlZh = child.getiterator(tag="carrierUrl-zh")[0].text
                carrierUrlEn = child.getiterator(tag="carrierUrl-en")[0].text
                enterpriseUrlZh = child.getiterator(tag="enterpriseUrl-zh")[0].text
                enterpriseUrlEn = child.getiterator(tag="enterpriseUrl-en")[0].text
                
                supportPatchPathDict = {"carrierUrl-zh":carrierUrlZh,
                                        "carrierUrl-en":carrierUrlEn,
                                        "enterpriseUrl-zh":enterpriseUrlZh,
                                        "enterpriseUrl-en":enterpriseUrlEn,
                                        }
                #字典归一
                hotPatchVersionDict = dict(modelPatchNameDict,**supportPatchPathDict)
                supportPatchPathList.append(hotPatchVersionDict)   
             
            supportPatchPathDictList = {"downloadUrl-user":supportPatchPathList}
            hotPatchVersionDict = dict(productPatchVersionDict,**supportPatchPathDictList)
            hotPatchVersionDictList.append(hotPatchVersionDict)       
                    
                
        return hotPatchVersionDictList
    except:
        logger.error("parse.product.hotpatch.file.filed, Exception:" + traceback.format_exc())
        return []