# -*- coding: UTF-8 -*-
import common
from common import selectErrorMsg

WARNING = 'WARNING'


# **************************************************************************** #
# 函数名称: execute
# 功能说明: I²C自修复检查
# 输入参数: ssh连接
# **************************************************************************** # 
def execute(ssh):
    errMsg = ""
    cliRet = ""
    lang = py_java_env.get("lang")

    isQryOk, deviceType, cliRet, errMsg = common.getDeviceType(ssh, lang)
    if not isQryOk:
        return (False, cliRet, errMsg)
    
    if deviceType not in ["S5500T", "S3900-M200", "S3900-M300"]:
        return (True, cliRet, "")
    
    #检查系统版本是否满足要求
    sysQryFlag, sysSpcVersion, cliRetSys, errMsgSys = common.getCurSystemVersion(ssh, lang)  
    cliRet += '\n' + cliRetSys
    if not sysQryFlag:
        #查询系统版本失败
        return (False, cliRet, errMsgSys)
    
    #阵列软件版本与热补丁版本对应关系
    verDict = {'V100R002C00SPC011' : 'V100R002C00SPHb01', 'V100R002C00SPC012' : 'V100R002C00SPHc01'}
    if sysSpcVersion not in verDict:
        return (True, cliRet, "")
    
    #查看系统是否安装热补丁
    isQryOk, curHotPatchVer, cliRetPatch, errMsgPatch = common.getCurHotPatchVersion(ssh, lang)
    cliRet += '\n' + cliRetPatch
    if not isQryOk:
        return (False, cliRet, errMsgPatch)
    
    #如果没有安装热补丁，建议优化
    if not curHotPatchVer:
        zhErrMsg = (u"\n系统未安装%s或之后的热补丁。" % verDict.get(sysSpcVersion) + 
                    u"\n更换硬盘或硬盘框时，可能无法识别新接入的硬盘或硬盘框。低概率出现单个控制器离线时RAID组故障。")
        enErrMsg = ("\nHot patch %s or later has not been installed." % verDict.get(sysSpcVersion) + 
                    "\nIn disk or disk enclosure replacement, new disk or disk enclosure may fail to be identified. In extreme cases, RAID group faults may occur when a controller goes offline.")
        errMsg = selectErrorMsg(lang, zhErrMsg, enErrMsg)
        return (WARNING, cliRet, errMsg)
    else:
        #安装了热补丁，巡检通过
        return (True, cliRet, errMsg)

