# -*- coding: UTF-8 -*-
import traceback
import re

from com.huawei.ism.tool.obase.exception import ToolException

from comm import modelManager
from comm.cTV1R1 import parseVertical
import common
from comm import compressionManager
import os


#TGT并发查询和延迟统计查
TGT_CONCURRENT_TYP = "TGT concurrent"
#和延迟统计查
DELAY_STATIS_TYP = "delay statistics"

def execute(cli):
    '''
    

    '''
    flag = True
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    contex = py_java_env
    sysSpcVersion = ""
    cliRet = ""
    errMsg = ""
    cliRetAll = ""
    try:
        #判断产品版本，V100R005C00SPC700版本之前则不涉及
        (flag, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
        if not flag:
            return (common.RESULT_NOCHECK, cliRet, errMsg)
        
        if sysSpcVersion < "V100R005C00SPC700":
            return common.RESULT_NOSUPPORT ,cliRet ,errMsg
        
        #V100R005C00和V100R005C01属于同一个级别，V100R005C01SPC700版本之前为不涉及
        if "V100R005C01" in sysSpcVersion and sysSpcVersion < "V100R005C01SPC700":
            return common.RESULT_NOSUPPORT ,cliRet ,errMsg
        
        common.refreshProcess(contex, 2, logger)
        
        #检查消息节点泄漏完成后无法登陆问题
        (flagitem, cliRet, errMsgItem) = checkLimit4MemLeak(cli, lang, logger)
        cliRetAll += cliRet   
        errMsg += errMsgItem  
        
        common.refreshProcess(contex, 4, logger)
        
        #检查4口FCoE或TOE接口卡，低概率发生OOPS的问题
        (flagitemCard, cliRet, errMsgItem) = checkLimit4InfModule(cli, lang, logger)
        cliRetAll += cliRet   
        errMsg += errMsgItem 
        
        common.refreshProcess(contex, 6, logger)
        
        #1、版本限制，受限版本不进行日志收集，巡检“未检查”
        #满足一种受限条件则巡检结果为“未检查”
        if flagitem ==common.LIMMIT_VERSION or flagitemCard ==common.LIMMIT_VERSION:
            return (common.RESULT_NOCHECK, cliRetAll, errMsg)
        
        #检查异常巡检失败
        if flagitem ==common.ERROR_LIMMIT_VERSION or flagitemCard ==common.ERROR_LIMMIT_VERSION:
            return (common.RESULT_NOCHECK, cliRetAll, errMsg)
        
        common.refreshProcess(contex, 8, logger)  
              
        #2、执行datacollect命令导出日志，获取一键收集日志的解压目录
        flag, dataCollectRet, errMsg, deCompressDestDir = compressionManager.getDataCollectDecompressDir(contex, cli, logger)
        cliRetAll += "\n" + dataCollectRet
        if not flag:
            return (common.RESULT_NOCHECK, cliRetAll, errMsg)

        common.refreshProcess(contex, 90, logger)   
              
        #3、TGT资源检查
        logger.info("check TGT resources start")
        folderNameList = [] 
        for folderName in os.listdir(deCompressDestDir):
            if not folderName.startswith("DebugLog"):
                folderNameList.append(folderName)
                flagitem, checkStr, errMsgItem = checkTGTResources(cli,deCompressDestDir, folderName, logger,lang)
                cliRetAll += "\n" + checkStr
                if flagitem != True:
                    logger.info("check TGT resources failed")
                    flag = flagitem
                    errMsg += errMsgItem 
        common.refreshProcess(contex, 93, logger) 
        #4、FC xchg资源检查
        logger.info("check FC xchg resources start")
        for folderName in os.listdir(deCompressDestDir):
            if not folderName.startswith("DebugLog"):
                flagitem, checkStr, errMsgItem = checkFcXchResources(cli,deCompressDestDir, folderName, logger,lang)
                cliRetAll += "\n" + checkStr
                if flagitem != True:
                    logger.info("check FC xchg resources failed")
                    flag = flagitem
                    errMsg += errMsgItem   
        common.refreshProcess(contex, 95, logger)
        #查看是否部分控制器收集成功
        logger.info("folderNameList : " +str(folderNameList))
        if len(folderNameList) == 1:
            errMsg += common.getMsg(lang, "collect.log.filed.part.of.controllers")
            if flag == True:
                flag = common.RESULT_NOCHECK
        common.refreshProcess(contex, 98, logger)        
        return (flag, cliRetAll, errMsg)
    except (ToolException, Exception) as e:
        logger.error(str(e))
        return (False, cliRetAll, common.getMsg(lang, "query.result.abnormal"))
    finally:
        common.reconnection_cli(cli, logger)
        common.refreshProcess(contex, 100, logger) 

def checkFcXchResources(cli,deCompressDestDir, folderName, logger, lang):
    '''
    @summary: 检查FC xchg资源，在阵列A、B控日志Other目录下的pangea_mmlinfo文件中搜索关键打印showxchg
            ，每个FC端口的Free资源小于10%，则巡检不通过；
    @param cli: cli对象
    @param deCompressDestDir: 日志包路径
    @param lang: 语言对象
    @param logger: 日志打印对象
    @return:
        flag:
            True: 检查通过
            False: 检查不通过
        cliRetAll: cli回显
        errMsg: 错误时的消息
    '''
    
    flag = True
    errMsg = ""
    checkStr = ""
    except_counter = 0
     
    #获取ip信息
    controllerIp = folderName.replace("_MAIN", "")
    
    #将设备IP转换为控制器ID
    try:
        dict = getDevIpCtrIdDict(cli,lang)
        if dict:
            controllerIp = dict[controllerIp]
    except:
        except_counter += 1
    #通过控制器Ip查找mml文件位置
    mmlFilePath = ""
    for root, dirs, files in os.walk(deCompressDestDir + os.sep + folderName, False):
        if 'pangea_mmlinfo' in files:
            mmlFilePath = root + os.sep + 'pangea_mmlinfo'
            break
    #解压后找不到pangea_mmlinfo文件认为日志解压失败 
    else:
        flag = common.RESULT_NOCHECK
        errMsg += common.getMsg(lang, "decompressing.log.file.failed",(controllerIp))
        return (flag, checkStr, errMsg)
    logger.info("Getting mml file path of controller( Ip: " + controllerIp + ") is: " + mmlFilePath)
    
    #打开pangea_mmlinfo文件
    fileInfo = ""
    try:
        file = open(mmlFilePath)
        fileInfo = file.read()
        file.close()
    except:
        flag = common.RESULT_NOCHECK
        errMsg += common.getMsg(lang, "open.messages.file.failed",(controllerIp,file))
        return (flag, checkStr, errMsg)
    
    mmlCmdRetList = fileInfo.split("MML>")
    for mmlCmdRet in mmlCmdRetList:
        if "showxchg" in mmlCmdRet:
            checkStr = "\n[Controller :" + controllerIp + "]: showxchg :" + mmlCmdRet + "\nMML>"
            logger.info("showxchg Ret is :" + str(checkStr))
            lines = mmlCmdRet.splitlines()
            for line in lines:
                if "Port" in line:
                    #获取showxchg回显关键字段,实例如下：
                    '''Port 110100 Xchg : Free=(4096) Aborted=(0) IniBusy=(0) TgtBusy=(0) Retry=(0) '''
                    portXchgList = line.split() 
                    fcPortId = portXchgList[1]
                    Free = float(portXchgList[4].split("=")[1].replace("(", "").replace(")", ""))
                    Aborted = float(portXchgList[5].split("=")[1].replace("(", "").replace(")", ""))
                    IniBusy = float(portXchgList[6].split("=")[1].replace("(", "").replace(")", ""))
                    TgtBusy = float(portXchgList[7].split("=")[1].replace("(", "").replace(")", ""))
                    Retry = float(portXchgList[8].split("=")[1].replace("(", "").replace(")", ""))
                    logger.info("FC xchg resources Value is:PortId:[%s],Free:[%s],Aborted:[%s],IniBusy:[%s],TgtBusy:[%s],Retry:[%s]" %(str(fcPortId),str(Free),str(Aborted),str(IniBusy),str(TgtBusy),str(Retry)))
                    #阈值计算与判断
                    sum_cli_field = Free + Aborted + IniBusy + TgtBusy + Retry
                    if sum_cli_field == 0:
                        logger.warn("The sum of every key field is zero and reset to 1")
                        sum_cli_field = 1
                    if Free/sum_cli_field < 0.10:
                        #将底层端口号转换为可读性端口号
                        SoltPortIDList = common.FcPortConvert(fcPortId)
                        SoltID = SoltPortIDList[0]
                        PortID = SoltPortIDList[1]
                        flag = False
                        errMsg += common.getMsg(lang, "FC.xchg.fc.card.resources.abnormal",(controllerIp,SoltID,PortID))
    
    return (flag, checkStr, errMsg)

def checkTGTResources(cli,deCompressDestDir, folderName, logger,lang):
    '''
    @summary: 检查TGT资源，
    1、上述关键打印在“driver[1] session count”之前的，Free Cmd/1024 小于5%，则巡检不通过；
    2、上述关键打印在“driver[1] session count”和“driver[5] session count”之间的，Free Cmd/4096 小于5%，则巡检不通过；
    3、上述关键打印在“driver[5] session count”和“driver[7] session count”之间的，Free Cmd/1024 小于5%，则巡检不通过；
    @param cli: cli对象
    @param deCompressDestDir: 日志包路径
    @param lang: 语言对象
    @param logger: 日志打印对象
    @return:
        flag:
            True: 检查通过
            False: 检查不通过
        cliRetAll: cli回显
        errMsg: 错误时的消息
    '''
    
    flag = True
    errMsg = ""
    errMsgAll = ""
    checkStr = ""
    checkStrAll = ""
    except_counter = 0
     
    #获取ip信息
    controllerIp = folderName.replace("_MAIN", "")
    
    #将设备IP转换为控制器ID
    try:
        dict = getDevIpCtrIdDict(cli,lang)
        if dict:
            controllerIp = dict[controllerIp]
    except:
        except_counter += 1
    messagesFilePath = ""
    messagesFileList = []
    for root, dirs, files in os.walk(deCompressDestDir + os.sep + folderName, False):
        for file in files:
            if 'messages_' in file:
                #构造messages日志包路径
                messagesroot = root
                messagesFileList.append(file)
                continue
    #解压后找不到messages_文件认为日志解压失败
    if messagesFileList == []:
        flag = common.RESULT_NOCHECK
        errMsg += common.getMsg(lang, "decompressing.log.file.failed",(controllerIp))
        return (flag, checkStr, errMsg)
            
    #将message日志文件按最新时间进行排列
    messagesFileList= sorted(messagesFileList,cmp=None,key=None,reverse=True)
    logger.info("MessagesFileList  is " + str(messagesFileList))
    
    #解析messages_xxxxxxxxxxxxxxxx信息文件
    fileInfo = ""
    for file in messagesFileList:
        messagesFilePath = messagesroot + os.sep + file
        
        try:
            file = open(messagesFilePath)
            fileInfo = file.read()
            file.close()
        except:
            flag = common.RESULT_NOCHECK
            errMsg += common.getMsg(lang, "open.messages.file.failed",(controllerIp,file))
            return (flag, checkStr, errMsg)
        #获取TGT资源检查的message文件数据
        if "driver[" in fileInfo:
            logger.info("get [%s] file successed" %(file))
            break
    
    #获取driver[1]，driver[5]，driver[5]的标记位    
    driver1Index = fileInfo.find("driver[1]")
    driver5Index = fileInfo.find("driver[5]")
    driver7Index = fileInfo.find("driver[7]")
    
    #构造driver[1]之前回显
    driver1Ret = fileInfo[:driver1Index]
    typ = "driver[1]" 
    hostFreeCmdAllList,hostFreeCmdRet = getHostAndFreeCmdDict(typ,controllerIp,driver1Ret)
    logger.info("Controller :[%s] driver[1] hostAndFreeCmdValue is :[%s]" %(controllerIp,hostFreeCmdAllList))
    checkStrAll += hostFreeCmdRet
    flagMark,errMsg = checkTgtFunction(controllerIp,hostFreeCmdAllList,typ,lang)
    if not flagMark:
        flag = False
        errMsgAll += errMsg
        
    if driver5Index != -1:
        typ = "driver[5]" 
        #构造driver[1]和driver[5]之间的回显
        driver5Ret = fileInfo[driver1Index:driver5Index]
        hostFreeCmdAllList,hostFreeCmdRet = getHostAndFreeCmdDict(typ,controllerIp,driver5Ret)
        logger.info("Controller :[%s] driver[5] hostAndFreeCmdValue is :[%s]" %(controllerIp,hostFreeCmdAllList))
        checkStrAll += hostFreeCmdRet
        flagMark,errMsg = checkTgtFunction(controllerIp,hostFreeCmdAllList,typ,lang)
        if not flagMark:
            flag = False
            errMsgAll += errMsg
            
    if driver7Index != -1:
        typ = "driver[7]"     
        #构造driver[5]和driver[7]之间的回显
        driver7Ret = fileInfo[driver5Index:driver7Index]
        hostFreeCmdAllList,hostFreeCmdRet = getHostAndFreeCmdDict(typ,controllerIp,driver7Ret)
        logger.info("Controller :[%s] driver[7] hostAndFreeCmdValue is :[%s]" %(controllerIp,hostFreeCmdAllList))
        checkStrAll += hostFreeCmdRet
        flagMark,errMsg = checkTgtFunction(controllerIp,hostFreeCmdAllList,typ,lang)
        if not flagMark:
            flag = False
            errMsgAll += errMsg
        
        
    return (flag, checkStrAll, errMsgAll)

def checkTgtFunction(controllerIp,hostFreeCmdAllList,typ,lang):
    '''
    @summary: TGT资源检查算法
    @param hostFreeCmdAllList: 端口和剩余TGT资源列表
    @param typ: TGT类型
    @return: 
            True:没超过阈值
            False:超过阈值
            errMsg：错误消息
    '''
    flag = True
    errMsg = ""
    for list in hostFreeCmdAllList:
        PortID = list[0]
        FreeCmd = list[1]
        if typ == "driver[1]":
            #将底层端口号转换为可读性端口号
            SoltPortIDList = common.FcPortConvert(PortID)
            SoltID = SoltPortIDList[0]
            PortID = SoltPortIDList[1]
            if float(FreeCmd)/float(1024) < 0.05:
                flag = False
                errMsg += common.getMsg(lang, "TGT.FC.card.resources.abnormal",(controllerIp,SoltID,PortID))
        if typ == "driver[5]":
            if float(FreeCmd)/float(4096) < 0.05:
                flag = False
                errMsg += common.getMsg(lang, "TGT.resources.abnormal",(controllerIp,PortID))
        if typ == "driver[7]":
            #将底层端口号转换为可读性端口号
            SoltPortIDList = common.FcPortConvert(PortID)
            SoltID = SoltPortIDList[0]
            PortID = SoltPortIDList[1]
            if float(FreeCmd)/float(1024) < 0.05:
                flag = False
                errMsg += common.getMsg(lang, "TGT.FC.card.resources.abnormal",(controllerIp,SoltID,PortID))
        
    return (flag,errMsg)
    
def getHostAndFreeCmdDict(typ,controllerIp,logret):
    '''
    @summary: 获取IO资源检查的Host和Free Cmd
    @param cliRet: 回显字典
    @return: Host和Free Cmd列表
    '''
    hostFreeCmdAllList = []
    cliRetList = logret.encode("utf8").splitlines()
    hostFreeCmdRet = ""
    for line in cliRetList:
        if "Host" in line and "Free Cmd" in line:
            startIndex = line.find("*****")
            endIndex = line.rindex("*****")
            hostFreeCmdLineRet = line[startIndex+5:endIndex]
            hostFreeCmdRet += "\n" + hostFreeCmdLineRet
            
            hostFreeCmdLineRetList = hostFreeCmdLineRet.split(" ")
            hostFreeCmdList =[]
            ID = hostFreeCmdLineRetList[0].replace("Host(","").replace(")","")
            freeCmd = hostFreeCmdLineRetList[2].replace("Cmd:","").replace(".","")
            
            hostFreeCmdList.append(ID)
            hostFreeCmdList.append(freeCmd)
            hostFreeCmdAllList.append(hostFreeCmdList)
    newNostFreeCmdRet = "[Controller :" + controllerIp +"]:" + typ + "Ret:"+ hostFreeCmdRet + "\n"
                       
    return (hostFreeCmdAllList,newNostFreeCmdRet)
# **************************************************************************** #
# 函数名称: checkLimit4MemLeak
# 功能说明: 检查消息节点泄漏完成后无法登陆问题
# 输入参数: devObj
# **************************************************************************** # 
def checkLimit4MemLeak(cli, lang, logger):

    CHECK_TYPE_LIST = ['S2600T', 'S5600T', 'S5500T', 'S2200T', 'S5800T', 'S6800T']
    SYS_PATCH_VER_MAP = {'V100R005C01SPC700':'V100R005C01SPH705',
                         'V100R005C00SPC700':'V100R005C00SPH705',
                         'V100R005C01SPC900':'V100R005C01SPH905',
                         'V100R005C00SPC900':'V100R005C00SPH905',
    }
    cliRetAll = ""
    #不限制收集的版本
    NoLimitVersion = "V100R005C02SPC300"

    #判断设备型号和版本
    (flag, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
    cliRetAll +=cliRet
    if not flag:
        return (common.ERROR_LIMMIT_VERSION, cliRet, errMsg)
    logger.info("[checkLimit4MemLeak] system version:" +  sysSpcVersion)
    if sysSpcVersion >= NoLimitVersion:
        return (common.NOT_LIMMIT_VERSION, cliRet, errMsg)
    if sysSpcVersion not in SYS_PATCH_VER_MAP:
        errMsg += common.getMsg(lang, "point.leak.error",(sysSpcVersion,NoLimitVersion))
        return (common.LIMMIT_VERSION, cliRet, errMsg)
    
    #判断设备类型
    (isQryOk, deviceType, cliRet, errMsg) = common.getDeviceType(cli, lang)
    cliRetAll +=cliRet
    logger.info("[checkLimit4MemLeak] Device type:" +  deviceType)
    if not isQryOk:
        return (common.ERROR_LIMMIT_VERSION, cliRetAll, errMsg) 
        
    if deviceType not in CHECK_TYPE_LIST:
        errMsg += common.getMsg(lang, "point.leak.error",(sysSpcVersion,NoLimitVersion))
        return (common.LIMMIT_VERSION, cliRetAll, errMsg) 
    
    #判断热补丁
    flag, cliRet ,hotPatchVer = common.getHotpatchVersion(cli, lang)
    cliRetAll +=cliRet
    if not flag:
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return (common.ERROR_LIMMIT_VERSION, cliRetAll, errMsg)   
    logger.info("[checkLimit4MemLeak] Hotpatch version:" +  hotPatchVer)
    
    #获取需要安装的热补丁
    needHotPatchVer = SYS_PATCH_VER_MAP.get(sysSpcVersion)
    if not hotPatchVer or hotPatchVer < needHotPatchVer:
        errMsg += common.getMsg(lang, "point.leak.error.patch",(sysSpcVersion,NoLimitVersion,needHotPatchVer))
        return (common.LIMMIT_VERSION,cliRetAll, errMsg)
    
    #日志下载不受限制
    return (common.NOT_LIMMIT_VERSION,cliRetAll, errMsg)
    

# **************************************************************************** #
# 函数名称: checkLimit4InfModule
# 功能说明: 检查4口FCoE或TOE接口卡，低概率发生OOPS的问题
# 输入参数: devObj
# **************************************************************************** # 
def checkLimit4InfModule(cli, lang,logger):

    SYS_PATCH_VER_MAP = {
                         'V100R005C30SPC500':'V100R005C30SPH501',
                         'V100R005C30SPC700':'V100R005C30SPH701',
    }

    #限制收集的开始版本
    LimitStartVersion = "V100R005C02SPC300"
    #已经解决的版本
    SolvedStartVersion = "V100R005C30SPC800"
    cliReAll = ""

    #判断设备版本
    (flag, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
    if not flag:
        return (common.ERROR_LIMMIT_VERSION, cliRet, errMsg)
    logger.info("[checkLimit4InfModule] system version:" +  sysSpcVersion)
    if sysSpcVersion < LimitStartVersion or sysSpcVersion >= SolvedStartVersion:
        return (common.NOT_LIMMIT_VERSION,cliRet, errMsg)
    
    queryOk, cliRet,existFlag = ifExistT4InfModule(cli, lang)
    cliReAll += cliRet
    logger.info("[checkLimit4InfModule] Exist T4 Interface Module:" +  str(existFlag))
    if not queryOk:
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return (common.ERROR_LIMMIT_VERSION, cliReAll, errMsg)   
    if not existFlag:
        #不存在4口FCoE或TOE接口卡，不限制
        return (common.NOT_LIMMIT_VERSION, cliReAll, errMsg)

    if sysSpcVersion not in SYS_PATCH_VER_MAP:
        errMsg += common.getMsg(lang, "TOE.or.FCoE.error")
        return (common.LIMMIT_VERSION,cliReAll, errMsg)

    #判断热补丁
    queryOk, cliRet,hotPatchVer = common.getHotpatchVersion(cli, lang)
    cliReAll += cliRet
    logger.info("[checkLimit4InfModule] Hotpatch version:" +  hotPatchVer)
    if not queryOk:
        errMsg = common.getMsg(lang, "query.result.abnormal")
        return (common.ERROR_LIMMIT_VERSION, cliReAll, errMsg) 
    
    #获取需要安装的热补丁
    needHotPatchVer = SYS_PATCH_VER_MAP.get(sysSpcVersion)
    if not hotPatchVer or hotPatchVer < needHotPatchVer:
        errMsg += common.getMsg(lang, "TOE.or.FCoE.error.patch",(needHotPatchVer))
        return (common.LIMMIT_VERSION,cliReAll, errMsg)
    
    #安装对应补丁版本，不受限制
    return (common.NOT_LIMMIT_VERSION,cliReAll, errMsg)


# **************************************************************************** #
# 函数名称: _ifExistT4InfModule
# 功能说明: 检查设备上是否存在4口FCoE或TOE接口卡
# 输入参数: cli
# **************************************************************************** # 
def ifExistT4InfModule(cli, lang):
    
    existFlag = False

    infModuleInfo = cli.execCmd("showifmodule")
    lineList = infModuleInfo.splitlines()
    #信息少于7行，查询信息失败
    if len(lineList) < 7:
        if "command operates successfully" in infModuleInfo:
            return (True, infModuleInfo,existFlag)
        return (False, infModuleInfo ,existFlag)
    for line in lineList:
        if not line.strip().startswith("Type"):
            continue
        if "4 x 10G FCoE Interface Module" in line or \
            "4 x 10GE Interface Module" in line:
            existFlag = True
            return (True, infModuleInfo,existFlag)
    return (True, infModuleInfo,existFlag)

def getDevIpCtrIdDict(cli,lang):
    '''
    @summary: 获取设备IP和控制器ID字典列表
    @param cli: CLI对象
    @return: 设备IP和控制器ID字典列表
    '''
    try:
        dict= {}
        cliRet = cli.execCmd("showctrlip")
        lines = cliRet.splitlines()
        
        # 从第7行开始，取出有效信息
        lineA = lines[6].split()
        ctrID = lineA[0]
        ctrIP = lineA[1]
        dict.setdefault(ctrIP,ctrID)
        lineB = lines[7].split()
        ctrID = lineB[0]
        ctrIP = lineB[1]
        dict.setdefault(ctrIP,ctrID)
        return dict
    except:
        return {}
    
    
    