# -*- coding: UTF-8 -*-
import common
import time
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 查询Lun延时
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 

logger = PY_LOGGER
PY_JAVA_ENV = py_java_env


def execute(cli):
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    lunIdList = []
    errMsg = ''
    cliRet = ''
    try:
        flag, sysSpcVersion, cmdRet, errMsg = common.getCurSystemVersion(cli, lang)
        if flag == False or sysSpcVersion == "":
            return (flag, cmdRet, errMsg)
        cliRet += cmdRet
        #V100R005C00SPC700之前版本不涉及，V100R005C00和V100R005C01属于同一个级别，V100R005C01SPC700版本之前为不涉及
        if sysSpcVersion < "V100R005C00SPC700" or ("V100R005C01" in sysSpcVersion and sysSpcVersion < "V100R005C01SPC700"):
            flag = common.RESULT_NOSUPPORT
            return (flag, cliRet, errMsg)
        
        # 刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 3, logger)
        
        cmdRet = cli.execCmd("showlun")
        cliRet += cmdRet
        #在命令发送中未取得正确回显
        cliRets = checkCliInfo("showlun", cmdRet, lang, False)
        if cliRets[0] != True:
            return (cliRets[0], cliRet, cliRets[1])
        
        # 刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 5, logger)   
             
        #步骤2与步骤3 整理出需要检查的Lun id
        lunIdMap, lunInfoFlag = getLunIdAndRgId(cli, cmdRet)
               
        if not lunIdMap :
            #如果所有Lun ID 均无映射关系业务，则通过 
            if lunInfoFlag:
                PY_LOGGER.info("All lunIds no map infomation!")
                return (True, cliRet, errMsg)
            #未取到关键信息的返回
            else:
                cliRets = checkCliInfo("showlun", cmdRet, lang, True)
                if cliRets[0] != True:
                    return (cliRets[0], cliRet, cliRets[1])
                
        # 刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 33, logger)
                
        #步骤4与步骤5查询Lun所属的分组硬盘类型   {'1': 'SAS', '0': 'SAS'}
        raidTypeRet = checkLunGroupDiskType(cli, lunIdMap, lang, cliRet)
        if raidTypeRet[0] == common.RESULT_NOCHECK:
            return (raidTypeRet[0], raidTypeRet[1], raidTypeRet[2])
        
        cliRet += raidTypeRet[1]
        
        # 刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 50, logger)
        
        #步骤6 检查所有lun延时情况 
        chkRet = checkLunLatency(cli, lunIdMap, raidTypeRet[3], lunInfoFlag, lang)
        common.refreshProcess(PY_JAVA_ENV, 90, logger)
        flag = chkRet[0]
        cliRet += chkRet[1]
        errMsg += chkRet[2]

        return (flag, cliRet, errMsg)
    except:
        return (common.RESULT_NOCHECK, cliRet, common.getMsg(lang, "query.result.abnormal"))
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, logger)

def checkLunGroupDiskType(cli, lunIdMap, lang, allCliRet):
# **************************************************************************** #
# 函数名称: checkLunDiskType
# 功能说明: 整理raid ID 与硬盘Type 配对
# 输入参数: lunIdMap,lang
# 输出参数: 无
# 返 回 值: raidType
# **************************************************************************** #    
    SASType = ''
    cliRets = []
    raidDiskInfo = {}
    raidAndLunMap = {}
    raidType = {}
    
    if len(lunIdMap) == 0:
        return True, allCliRet, '', raidType
    
    currentProcess = 35     
    singleStep = 10 / len(lunIdMap)
       
    #查找raid id 对应的分组disk信息
    for raidGroupId in lunIdMap:
        cliRetDiskInfo = cli.execCmd("showrg -rg " + raidGroupId)      
        allCliRet += cliRetDiskInfo
        cliRets = checkCliInfo("showrg -rg", cliRetDiskInfo, lang, False)
        if cliRets[0] != True:
            return (cliRets[0], allCliRet, cliRets[1], raidType)    
            
        diskInfo = common.getHorizontalStandardCliRet(cliRetDiskInfo)
        raidDisk = diskInfo.get('Member Disk List')
        if '--' in raidDisk:
            cliRets = checkCliInfo("showrg -rg", cliRetDiskInfo, lang, True)
            if cliRets[0] != True:
                return (cliRets[0], allCliRet, cliRets[1], raidType)  
                    
        raidDiskInfo.setdefault(raidGroupId, raidDisk)
        
        # 刷新进度条      
        currentProcess = common.refreshProcessByStep(currentProcess, singleStep, PY_JAVA_ENV, logger)
        
    #查找disk对应的type信息 
    cliRetDiskType = cli.execCmd("showdisk -physic")
    allCliRet += cliRetDiskType
    cliRets = checkCliInfo("showdisk", cliRetDiskType, lang, False)
    if cliRets[0] != True:   
        return (cliRets[0], allCliRet, cliRets[1], raidType) 
    diskTypeMap = getDiskTypeMap(cliRetDiskType)
        
    #确定rgId与diskId
    rgIdList = raidDiskInfo.keys() 
    diskIdList = diskTypeMap.keys()
    
    #存放 raid ID 与 对应diskType
    for rgId in rgIdList :
        diskInfo = raidDiskInfo.get(rgId)
        diskGroup = diskInfo.split(";")
        
        diskGroup = ['(%s)' % id for id in diskGroup]
        for diskInfoId in diskGroup :
            SASType = diskTypeMap.get(diskInfoId)
            if SASType and (SASType != '--'):
                raidType.setdefault(rgId, SASType)
                break
    if not raidType:
        cliRets = checkCliInfo("showdisk", cliRetDiskType, lang, True)
        if cliRets[0] != True:   
            return (cliRets[0], allCliRet, cliRets[1], raidType)          
                       
    return True, allCliRet, '', raidType 

def getLunIdAndRgId(cli, cliRet):
# **************************************************************************** #
# 函数名称: getLunIdMap
# 功能说明: 整理出需要检查的存在映射业务的Lun ID
# 输入参数: cliRet
# 输出参数: 无
# 返 回 值: lunIdMap
# **************************************************************************** #    
    lunInfoFlag = True
    list = cliRet.splitlines()
    lunIdMap = {}
    for line in list[6:]:
        lineList = line.split()
        if len(lineList) > 2:
            lunStatus = lineList[3].strip().lower()
            lunId = lineList[0].strip().lower()
            raidGroupId = lineList[1].strip().lower()
            if '--' in lunId:
                lunInfoFlag = False
                continue 
            
            if '--' in raidGroupId or not raidGroupId:
                continue
            
            if lunStatus == 'normal':
                if lunId != '--' and lunId.isdigit():
                    lunIdMap.setdefault(raidGroupId, []).append(lunId) 
    
    if len(lunIdMap) == 0:
        return (lunIdMap, lunInfoFlag) 
                    
    # 刷新进度条
    common.refreshProcess(PY_JAVA_ENV, 7, logger)   
    currentProcess = 8
    singleStep = 20 / len(lunIdMap)
       
    #剔除掉没有相关业务的Lun id
    for raidkey in lunIdMap:
        lunRaidList = lunIdMap.get(raidkey)
        notHostMapLunIdList = []
        for lunId in lunRaidList :
            isLunRaid = cli.execCmd("showhostmap -lun " + lunId)
            if 'command operates successfully, but no information' in isLunRaid:
                notHostMapLunIdList.append(lunId)
        for lunId in notHostMapLunIdList:
            lunRaidList.remove(lunId)
        #更新    lunIdMap
        if len(lunRaidList) > 0:          
            lunIdMap.setdefault(raidkey, lunRaidList)    
        currentProcess = common.refreshProcessByStep(currentProcess, singleStep, PY_JAVA_ENV, logger)                                
    return (lunIdMap, lunInfoFlag) 

def getDiskTypeMap(cliRet):
# **************************************************************************** #
# 函数名称: getDiskTypeMap
# 功能说明: 整理硬盘type
# 输入参数: cliRet
# 输出参数: 无
# 返 回 值: diskTypeMap
# **************************************************************************** #    
    list = cliRet.splitlines()
    diskTypeMap = {}
    for line in list[6:]:
        lineList = line.split()
        if len(lineList) > 2:
            diskTypeMap.setdefault(str(lineList[0]), str(lineList[2]))
    return diskTypeMap

def checkLunLatency(cli, lunIdMap, raidType, lunInfoFlag, lang):
# **************************************************************************** #
# 函数名称: checkLunLatency
# 功能说明: 判断LUN的延时
# 输入参数: lunIdList,lang
# 输出参数: 无
# 返 回 值: flag, allCliRet, errMsg
# **************************************************************************** #
    errorLunIdList = []
    allCliRet = ''
    errMsg = ''
    flag = True
    warnFlag = False
    failFlag = False
    noCheckFlag = False
    count = 0
    SLEEP_TIME = 10
    readOrWriteFailLunIdList = {}
    readOrWriteWarningLunIdList = {}
 
    #检查show lun查询开关
    chkRet = common.getPerfSwitchStatus(cli)
    allCliRet += chkRet[0]
    if chkRet[1] == "off":
        checkRet = common.chgPerfSwitchStatus(cli, "on")
        allCliRet += checkRet[1]
        if not checkRet[0]:
            flag = False
            errMsg += common.getMsg(lang, "fail.set.perfswitchstatus")
            return flag, allCliRet, errMsg
    
    if len(lunIdMap) == 0:
        return flag, allCliRet, errMsg
        
    common.refreshProcess(PY_JAVA_ENV, 52, logger)
    currentProcess = 55       
    #循环检查lun id是否延迟
    while (count < 3):
        if not readOrWriteFailLunIdList and count == 0:
            singleStep = 30 / len(lunIdMap)
            for idkey in lunIdMap:
                #当前raid组 所对应的Lun ID 以及对应的硬盘Type
                lunIdList = lunIdMap.get(idkey)
                diskType = raidType.get(idkey).strip()
                
                for lunId in lunIdList:
                    cliRet, lunId, diskType, checkResult, errorId = queryLunLatency(cli, lunId, diskType, lang)
                    if checkResult == 'readOrWriteFail' :
                        readOrWriteFailLunIdList.setdefault(lunId, diskType)
                    elif checkResult == 'readOrWriteWarning' :
                        readOrWriteWarningLunIdList.setdefault(lunId, diskType)
                        allCliRet += cliRet
                    if errorId != '':
                        allCliRet += cliRet
                        errorLunIdList.append(errorId)
                        
                currentProcess = common.refreshProcessByStep(currentProcess, singleStep, PY_JAVA_ENV, logger)
             
        elif readOrWriteFailLunIdList :
            time.sleep(SLEEP_TIME)
            failLunIdList = readOrWriteFailLunIdList.keys()
            for failLunId in failLunIdList :
                diskType = readOrWriteFailLunIdList.get(failLunId)
                cliRet, lunId, diskType, checkResult, errorId = queryLunLatency(cli, failLunId, diskType, lang)
                if checkResult == 'readOrWriteFail' :
                    allCliRet += cliRet
                elif checkResult == 'readOrWriteWarning' :
                    readOrWriteWarningLunIdList.setdefault(lunId, diskType)
                    allCliRet += cliRet
                    del readOrWriteFailLunIdList[failLunId]
                    if not readOrWriteFailLunIdList :
                        break
                elif checkResult == '' :
                    del readOrWriteFailLunIdList[failLunId]
                    if not readOrWriteFailLunIdList :
                        break
        
        count += 1
    
    #关闭查询开关
    if chkRet[1] == "off":
        checkRet = common.chgPerfSwitchStatus(cli, "off")
        allCliRet += checkRet[1]

    if len(readOrWriteFailLunIdList) > 0 :
        failFlag = True
        errMsg += common.getMsg(lang, "readlatency.fail.lun", ",".join(readOrWriteFailLunIdList))
    if len(readOrWriteWarningLunIdList) > 0:
        warnFlag = True
        errMsg += common.getMsg(lang, "readlatency.warning.lun", ",".join(readOrWriteWarningLunIdList))
    if len(errorLunIdList) > 0:
        noCheckFlag = True 
        errMsg += common.getMsg(lang, "cannot.get.lunnocheck.info", ",".join(errorLunIdList))
    PY_LOGGER.info("readOrWriteFailLunIdList:" + str(readOrWriteFailLunIdList))
    PY_LOGGER.info("readOrWriteWarningLunIdList:" + str(readOrWriteWarningLunIdList))
    PY_LOGGER.info("errorLunIdList:" + str(errorLunIdList))
    if failFlag:
        flag = False
    elif warnFlag:
        flag = common.RESULT_WARNING
    elif noCheckFlag:
        flag = common.RESULT_NOCHECK     
    else:
        if lunInfoFlag:
            flag = True
        else:
            cliRets = checkCliInfo("showlun", allCliRet, lang, True)
            if cliRets[0] != True:
                return (cliRets[0], cliRet, cliRets[1])                
            
    PY_LOGGER.info("errMsg:" + errMsg)
      
    return (flag, allCliRet, errMsg)
# **************************************************************************** #
# 函数名称: queryLunLatency
# 功能说明: 输出单个Lun 的延时查询
# 输入参数: cli,lunId,diskType,lang
# 输出参数: 无
# 返 回 值: cliRet,lunId,diskType,checkResult
# **************************************************************************** #
def queryLunLatency(cli, lunId, diskType, lang):
    errorId = ''
    checkResult = ''
    cliRet = cli.execCmd("showperf -lun " + lunId)
    #判断cli回显信息是否满足要求
    list = cliRet.splitlines()
    if len(list) < 5:
    #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            errorId = lunId
    else:
        flag, checkResult = chkSingleLunLatency(cliRet, diskType)
        if flag != True:
            errorId = lunId
            
    PY_LOGGER.info("ReturnVaule:" + checkResult + " lun_ID:" + lunId)
    return cliRet, lunId, diskType, checkResult, errorId
            
def chkSingleLunLatency(cliRet, diskType):
# **************************************************************************** #
# 函数名称: chkSingleLunLatency
# 功能说明: 判断单个LUN的延时
# 输入参数: cliRet,lang
# 输出参数: 无
# 返 回 值: flag, errMsg
# **************************************************************************** #
    readOrWriteFlag = ''
    
    #获取LUN的Average Read I/O Latency (ms)，Average Write I/O Latency (ms)的值然后进行判断
    perfDict = common.getHorizontalStandardCliRet(cliRet)
    avgReadLatency = perfDict.get("Average Read I/O Latency (ms)", "")
    avgWriteLatency = perfDict.get("Average Write I/O Latency (ms)", "")
    
    PY_LOGGER.info("avgReadLatency:" + avgReadLatency + " avgWriteLatency:" + avgWriteLatency)
    
    if ('--' in avgReadLatency) or ('--' in avgWriteLatency):
        return (False, readOrWriteFlag)
    
    #通过diskType 经行该项Lun ID 所需的警戒阀值判断
    if avgReadLatency and avgWriteLatency:
        if 'FC' == diskType or 'SAS' == diskType:
            if (float(avgReadLatency) > 30) or (float(avgWriteLatency) > 30) : 
                readOrWriteFlag = 'readOrWriteFail'
            elif (20 <= float(avgReadLatency) <= 30) or (20 <= float(avgWriteLatency) <= 30):
                readOrWriteFlag = 'readOrWriteWarning'
        elif 'SATA' == diskType or 'NL SAS' in diskType or 'NL' in diskType:
            if (float(avgReadLatency) > 60) or (float(avgWriteLatency) > 60) : 
                readOrWriteFlag = 'readOrWriteFail'
            elif (40 <= float(avgReadLatency) <= 60) or (40 <= float(avgWriteLatency) <= 60):
                readOrWriteFlag = 'readOrWriteWarning' 
        elif 'SSD' == diskType :
            if (float(avgReadLatency) > 20) or (float(avgWriteLatency) > 20) : 
                readOrWriteFlag = 'readOrWriteFail'
            elif (10 <= float(avgReadLatency) <= 20) or (10 <= float(avgWriteLatency) <= 20):
                readOrWriteFlag = 'readOrWriteWarning' 
    return (True, readOrWriteFlag)

def checkCliInfo(cmd, cmdRet, lang, infoFlag):
# **************************************************************************** #
# 函数名称: checkCliInfo
# 功能说明: 判断cli命令发送是否异常
# 输入参数: cliRet,lang
# 输出参数: 无
# 返 回 值: flag, errMsg
# **************************************************************************** #  
    errMsg = ""
    cmdInfo = ""
    list = cmdRet.splitlines()
    flag = (len(list) < 7) and (not common.checkCliInfoValid(cmdRet, False))

    if flag or infoFlag:
        if 'showlun' in cmd:
            if lang == 'zh':
                cmdInfo = u'所有lun的信息'
            else:
                cmdInfo = 'all LUNs information'
        if 'showrg' in cmd:
            if lang == 'zh':
                cmdInfo = u'查询RAID组的信息'
            else:
                cmdInfo = 'RAID groups information'
        if 'showdisk' in cmd:
            if lang == 'zh':
                cmdInfo = u'查询硬盘物理信息'
            else:
                cmdInfo = 'physical disks information'
        
        errMsg = common.getMsg(lang, "latencylunio.command.faile", cmdInfo)
        return (common.RESULT_NOCHECK, errMsg)
    return (True, errMsg)     