﻿# -*- coding: UTF-8 -*-

"""P11G-5580 Lun负载均衡巡检项增加 20121204 added Begin"""
import re
import string
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 查询Lun负载均衡状态
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    showlun命令回显
    【V1R1】
    admin:/>showlun
    ====================================================================================================
                                              LUN Information                                           
    ----------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Status    Controller    Capacity(MB)    LUN Name     Stripe Unit Size(KB)  
    ----------------------------------------------------------------------------------------------------
      0     --               Normal    A             4096.0          LUN001_1     64                    
      1     0                Normal    A             2048.0          LUN001_2     64         
    ====================================================================================================    
    【V1R2】
    admin:/>showlun
    =========================================================================================================================================
                                                                 LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             1024.0                  LUN001_001    64                      FAT       
      1     0                --              Normal    B             1024.0                  LUN001_002    64                      FAT       
    =========================================================================================================================================
    """
    
    tempOwnController = ""
    tempWorkController = ""
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    errCounter = 0
    logger = PY_LOGGER
    PY_JAVA_ENV = py_java_env
    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    """判断cli回显信息是否满足要求"""
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."  
        return (flag, cliRet, errMsg)
    
    # 刷新进度条
    common.refreshProcess(PY_JAVA_ENV, 5, logger) 
    
    currentProcess = 10     
    singleStep = 85 / (len(list) - 6)   
    for field in list[6:]:
        
        luninfo = field.split()
        if len(luninfo) < 7:
            continue
        else:
            lunId = luninfo[0]
            #查询每一个Lun的负载均衡信息
            iRet = checklunloadbalance(cli, lunId)
            
            if False == iRet[0] and errCounter < 10:
                cliRet += '\n\n' + iRet[1]
                errCounter += 1
            
            tempOwnController = iRet[2]
            tempWorkController = iRet[3]
            #设置错误显示信息

            
            if False == iRet[0]:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLUN（LUN ID：" + unicode(lunId)+ u"）的负载不均衡（所属控制器ID：" + unicode(tempOwnController)\
                                + u"，工作控制器ID：" + unicode(tempWorkController) + u"）。"
                else:
                    errMsg += "\nThe load balance status of LUN (lun-id:" + unicode(lunId) \
                            +") is not normal (owning-controller-id:" + unicode(tempOwnController) \
                            + u", working-controller-id:" + unicode(tempWorkController) + u")."
        currentProcess = common.refreshProcessByStep(currentProcess, singleStep, PY_JAVA_ENV, logger)
    common.refreshProcess(PY_JAVA_ENV, 100, logger)                        
    return (flag, cliRet, errMsg)
    
# **************************************************************************** #
# 函数名称: checklunloadbalance
# 功能说明: 查询Lun的负载不均衡
# 输入参数: cli, lunId
# 输出参数: 无
# 返 回 值: flag, cliRet, unicode(OwnController), unicode(WorkController)
# **************************************************************************** # 
def checklunloadbalance(cli, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    OwnController = ''
    WorkController = ''
    flag = True
    
    cliRet = cli.execCmd("showlun -lun " + unicode(lunId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    #P11G-5704 私有Lun不进行检查 added 20130218 Begin
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (True, cliRet, '', '')
            else:
                break
        else:
            continue

    if count < 20:
        return(False, cliRet, '', '')
    #P11G-5704 私有Lun不进行检查 added 20130218 End

    """查询制定Lun的控制器信息"""
    OwnController = (list[12].split())[3]
    WorkController = (list[13].split())[3] 
    
    if OwnController != WorkController:
        flag = False
    return(flag, cliRet, unicode(OwnController), unicode(WorkController))

"""P11G-5580 Lun负载均衡巡检项增加 20121204 added End"""
 