# -*- coding: UTF-8 -*-
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: LUN状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    """
    showlun命令回显
    【V1R1】
    admin:/>showlun
    ====================================================================================================
                                              LUN Information                                           
    ----------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Status    Controller    Capacity(MB)    LUN Name     Stripe Unit Size(KB)  
    ----------------------------------------------------------------------------------------------------
      0     --               Normal    A             4096.0          LUN001_1     64                    
      1     0                Normal    A             2048.0          LUN001_2     64         
    ====================================================================================================    
    【V1R2】
    admin:/>showlun
    =========================================================================================================================================
                                                                 LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             1024.0                  LUN001_001    64                      FAT       
      1     0                --              Normal    B             1024.0                  LUN001_002    64                      FAT       
    =========================================================================================================================================
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    newVerFlag = False

    #发送命令
    cliRet = cli.execCmd("showlun")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."           
        return (flag, cliRet, errMsg)
    #判断是否为新版本回文
    if re.search("Disk Pool ID", cliRet, re.IGNORECASE):
        newVerFlag = True

    for field in list[6:]:
            list2 = field.split()
            if len(list2) < 4:
                continue
            #变量初始化
            lunStatus = ""
            lunStatusTmp = ""
            #特殊回显信息标志
            tempFlag = True
            raidId = list2[1]
            diskPoolId = ""
            
            #新版本信息，取出DiskPoolID信息
            if newVerFlag:
                diskPoolId = list2[2]
            
            if re.search("Not format", field, re.IGNORECASE):
                lunStatusTmp = "Not format"
            elif re.search("Init fail", field, re.IGNORECASE):
                lunStatusTmp = "Init fail"
            elif re.search("Delete fail", field, re.IGNORECASE):
                lunStatusTmp = "Delete fail"
            else:
                tempFlag = False
            
            #判断是否为特殊的回显信息
            if tempFlag:
                lunStatus = lunStatusTmp
                if newVerFlag:
                    lunName = list2[7]
                else:
                    lunName = list2[6]
            else:
                if newVerFlag:
                    lunStatus = list2[3]
                    lunName = list2[6]
                else:
                    lunStatus = list2[2]
                    lunName = list2[5]

            #Normal和Formatting都需要通过
            if lunStatus not in ("Normal", "Formatting"):
                flag = False
                
                if raidId != "--":
                    if "zh" == lang:
                        errMsg += u"\nRAID组（RAID组ID：" + raidId + u"）的LUN（LUN名称：" + lunName + u"）的状态存在异常（" + lunStatus + u"）。"
                    else:
                        errMsg += u"\nThe status of LUN (lun-name:" + lunName + u") of RAID group(raid-group-id:" + raidId\
                                  + u") is abnormal(" + lunStatus + u")."
                elif diskPoolId not in ["--", ""]:
                    if "zh" == lang:
                        errMsg += u"\n精简池（精简池ID：" + diskPoolId + u"）的LUN（LUN名称：" + lunName + u"）的状态存在异常（" + lunStatus + u"）。"
                    else:
                        errMsg += u"\nThe status of LUN (lun-name:" + lunName + u") of Thin pool(thin-pool-id:" + diskPoolId\
                                  + u") is abnormal(" + lunStatus + u")."
                else:
                    continue

    return (flag, cliRet, errMsg)