# -*- coding: UTF-8 -*-

import re
import string
import common
import traceback

WARNING = 'WARNING'
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 查询LUN透写配置
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """"cli命令回显信息
    showlun
    =========================================================================================================================================
                                                LUN Information
    -----------------------------------------------------------------------------------------------------------------------------------------
      ID    RAID Group ID    Disk Pool ID    Status    Controller    Visible Capacity(MB)    LUN Name      Stripe Unit Size(KB)    Lun Type  
    -----------------------------------------------------------------------------------------------------------------------------------------
      0     0                --              Normal    A             57344.0                 LUN001        64                      FAT       
      1     0                --              Normal    B             57344.0                 LUN002        64                      FAT       
      2     1                --              Normal    A             96256.0                 LUN003_001    64                      FAT       
    =========================================================================================================================================
    
    admin:/>"""
    
    tempCacheWriteStrategy = ""
    flag = True
    cliRet = ""
    errMsg = ""
    errCounter = 0
    logger = PY_LOGGER
    PY_JAVA_ENV = py_java_env
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("showlun")
        list = cliRet.splitlines()
        """判断cli回显信息是否满足要求"""
        if len(list) < 7:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCLI信息无效。"
                else:
                    errMsg = "\nInvalid CLI information."          
            return (flag, cliRet, errMsg)
        common.refreshProcess(PY_JAVA_ENV, 5, logger)
        
        currentProcess = 10     
        singleStep = 85 / (len(list)-6)
               
        for field in list[6:]:
            luninfo = field.split()
            if len(luninfo) < 7:
                continue
            
            lunId = luninfo[0]
            #查询每一个LUN的Cache写策略是否为透写
            iRet = checkWriteThrough(cli, lunId)
            tempCacheWriteStrategy = iRet[2]
            
            if WARNING == iRet[0]:
                flag = WARNING
                if not tempCacheWriteStrategy:      #LUN信息无效的情况
                    if "zh" == lang:
                        errMsg += u'\nLUN（ID:' + unicode(lunId) + u'）的信息无效。'
                    else:
                        errMsg += '\nLUN(ID:' + unicode(lunId) + ') information is invalid.'
                else:
                    if "zh" == lang:
                        errMsg += u"\nLUN（ID：" + unicode(lunId)+ u"）配置的Cache写策略为" + unicode(tempCacheWriteStrategy) + u"。"
                    else:
                        errMsg += "\nLUN(ID:" + unicode(lunId) + ") Cache Write Strategy is configured to " + unicode(tempCacheWriteStrategy) + "."
                if errCounter < 10:
                    cliRet += '\n\n' + iRet[1]
                    errCounter += 1
                    
            # 刷新进度条      
            currentProcess = common.refreshProcessByStep(currentProcess, singleStep, PY_JAVA_ENV, logger)
                
        return (flag, cliRet, errMsg)
    except Exception,e:
        PY_LOGGER.error("TV1Inspect[LUNWriteThrough] catch except of trace back:" + unicode(traceback.format_exc()))
        return (False, cliRet, errMsg)
    finally:
        common.refreshProcess(PY_JAVA_ENV, 100, logger)
    
# **************************************************************************** #
# 函数名称: checkWriteThrough
# 功能说明: 查询LUN是否配置为透写
# 输入参数: cli, lunId
# 输出参数: 无
# 返 回 值: flag, cliRet, RunCacheWriteStrategy
# **************************************************************************** # 
def checkWriteThrough(cli, lunId):
    
    """cli命令回显信息
    admin:/>showlun -lun 0    
    ===================================================================
                              LUN Information
    -------------------------------------------------------------------
      ID                           | 0
      Name                         | LUN001
      LUN WWN                      | 630397510068393001869d9b00000000
      Status                       | Normal
      Visible Capacity(MB)         | 57344.0
      Stripe Unit Size(KB)         | 64
      RAID Group ID                | 0
      Format Progress(%)           | --
      Owning Controller            | A
      Working Controller           | A
      Cache Prefetch Strategy      | Intelligent
      Cache Write Strategy         | Write back; Mirroring
      Running Cache Write Strategy | Write back; Mirroring
      Change stripped size         | --
      Stripe Unit Size Progress(%) | --
      Stripe Unit Size Speed       | --
      Extending LUN                | --
      Lun Type                     | FAT
      Consumed Capacity(MB)        | --
      Reclaim Progress(%)          | --
      Pool ID                      | --
      SnapShot ID                  | 6
      LunCopy ID                   | 0
      Whether Private LUN          | No
      Remote Replication ID        | 3039756839300000
      Split mirror ID              | --
    ===================================================================
        
    admin:/>"""
    #信息初始化
    cacheWriteStrategy = ''
    flag = True
    
    cliRet = cli.execCmd("showlun -lun " + unicode(lunId))
    list = string.split(cliRet, '\n')
    
    """判断cli回显信息是否满足要求"""
    count = len(list)
    for index in range(count):
        if re.search('Whether Private LUN', list[index], re.IGNORECASE):
            if re.search('Yes', list[index], re.IGNORECASE):
                return (True, cliRet, '', '')
            else:
                break

    if count < 20:      #获取到的LUN信息无效，返回警告
        return(WARNING, cliRet, cacheWriteStrategy)

    """查询LUN配置的Cache写策略"""
    for field in list:
        if bool(re.search('Cache Write Strategy', field, re.IGNORECASE)):
            cacheWriteStrategy = field.split('|')[1].strip()
            if 'Write through' in cacheWriteStrategy:
                flag = WARNING
            break
    return(flag, cliRet, cacheWriteStrategy)
    