# -*- coding: UTF-8 -*-
import traceback
import re
from comm import modelManager
from comm.cTV1R1 import parseVertical
import common


def execute(cli):
    """
    LUN的Cache资源检查
    1 showcacheluninfo -lun lunid回显中计算local control为1控制器的单个LUN的水位，如果(dirty count - lun high level)/(lun quota - lun high level)超过50%则巡检不通过；
    2 showcacheluninfo -lun lunid回显中计算local control为1控制器的单个LUN的刷盘并发数，如果send raid cur num/send raid max num超过90%则巡检不通过；
    3 showcacheluninfo -lun lunid回显中计算local control为1控制器的单个LUN的刷盘页面数，如果destage page num /max destage pages超过90%则巡检不通过；
    4 showcacheluninfo -lun lunid回显中计算local control为1控制器的单个LUN的离散chunk数，如果discrete chunk/discrete quota超过90%则巡检不通过；
    """
    try:
        flag = True
        errMsg = ""
        lang = py_java_env.get("lang")
        logger = PY_LOGGER
        sysSpcVersion = ""
        cliRet = ""
        cliRetAll = ""
        #判断产品版本，V100R005C00SPC700版本之前则不涉及
        (flag, sysSpcVersion, cliRet, errMsg) = common.getCurSystemVersion(cli, lang)
        
        if not flag:
            return (flag, cliRet, errMsg)
        
        cliRetAll += cliRet
        if sysSpcVersion < "V100R005C00SPC700":
            return common.RESULT_NOSUPPORT ,cliRetAll ,errMsg
        
        #V100R005C00和V100R005C01属于同一个级别，V100R005C01SPC700版本之前为不涉及
        if "V100R005C01" in sysSpcVersion and sysSpcVersion < "V100R005C01SPC700":
            return common.RESULT_NOSUPPORT ,cliRetAll ,errMsg
        
        #进入Developer模式
        flag = modelManager.changeCli2Developer(cli, py_java_env)
        if not flag:
            flag = False
            errMsg = common.getMsg(lang, "enter.developer.fail")
            return (flag, cliRetAll, errMsg)
        
        flag, cliRet, errMsg= common.checkLunCacheResourse(cli,lang,logger)
        
        cliRetAll += cliRet
        #退出Developer模式进入CLI模式
        modelManager.changeAnyModel2Cli(cli)    
        return (flag, cliRetAll, errMsg)
        
    except Exception, exception:
        logger.error(str(exception))
        return (False, cliRet, common.getMsg(lang, "query.result.abnormal"))
