# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 阵列间链路状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    
    cliRet = cli.execCmd("showrmtlink")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."          
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        if list2[3] != "Connected":
            flag = False
            if "zh" == lang:
                errMsg += u"\n阵列间链路（链路ID：" + list2[0] + u"）的状态存在异常（" + list2[3] + u"）。"
            else:
                errMsg += "\nThe status of link (link-id:" + list2[0]\
                          + ") is abnormal(" + list2[3] + ")."

    return (flag, cliRet, errMsg)