# -*- coding: UTF-8 -*-
import re
import common

CHECK_RESULT_PASS = "True"
CHECK_RESULT_WARNING = "WARNING"

""" 性能转储巡检 20130709 added Begin"""
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 性能转储巡检项
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    admin:/>showupgradepkginfo -t 1
    ========================================================
    			  Upgrade Package Information
    --------------------------------------------------------
      Controller ID    Package Version      Package Status
    --------------------------------------------------------
      A                V100R005C00SPC800    Running
      B                V100R005C00SPC800    Running
    ========================================================
    admin:/>
    
    admin:/>showperfrestore
    =================================
     Statistic Restore Configuration
    ---------------------------------
      Restore Switch  | off
      Restore Address |
      Restore Path    |
      Restore Account |
    =================================
    admin:/>
    
    admin:/>hw_chgalarmmask -i 60163817496 -m 1
    command operates successfully.
    admin:/>
    
    admin:/>hw_showalarmmask
    ==========================
    		 Mask ID
    --------------------------
      alarm id | 60163817496
    ==========================
    """
    AlarmMask = False
    flag = CHECK_RESULT_PASS
    lang = py_java_env.get("lang")
    curCVersion = ""
    currentVer = ""
    version = ""
    errMsg = ""
    cliRet = ""
    
    #性能转储巡检项优化 20130922 added begin
    iRet = cli.execCmd("showperfrestore")
    cliRet += iRet
    if re.search("off", cliRet, re.IGNORECASE):
        return (CHECK_RESULT_PASS, cliRet, "")
    else:
        lines = iRet.splitlines()
        if len(lines) < 7:
            #判断cli信息是否有效
            if not common.checkCliInfoValid(iRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\nCli信息无效。"
                else:
                    errMsg = "\nInvalid CLI information." 
            return (flag, cliRet, errMsg)
    #性能转储巡检项优化 20130922 added end
    
    iRet = cli.execCmd("hw_showalarmmask")
    cliRet += iRet

    if re.search("60163817496", iRet):
        AlarmMask = True
    
    #"""获取系统软件版本号,判断是否需要提示屏蔽""" 
    iRet = cli.execCmd("showupgradepkginfo -t 1")
    cliRet += iRet
    
    lines = iRet.splitlines()
    if len(lines) < 7:
        flag = False
        if lang == "zh":
            errMsg = u"\nCli信息无效。"
        else:
            errMsg = "\nInvalid CLI information." 
        return (flag, cliRet, errMsg)
    
    # 从第7行开始，取出有效信息
    for line in lines[6:]:
        field = line.split()
        if len(field) < 3:
            break
    
        # 只取出正在运行的版本号
        if "Running" == field[2]:
            # 构造版本信息字符串
            version = field[1]
            #示例：V100R002C00SPCh00
            currentVer = version[version.index("V100"):version.index("V100") + 17]
            #示例：V100R002C00
            curCVersion = version[version.index("V100"):version.index("V100") + 11]

            break
        
    #检查当前版本是否需要修复
    if "V100R002C00" == curCVersion:
        if "V100R002C00SPC015" <= currentVer <= "V100R002C00SPCh00":
            if False == AlarmMask:
                flag = CHECK_RESULT_WARNING 
        elif currentVer > "V100R002C00SPCh00":
            if True == AlarmMask:
                flag = CHECK_RESULT_WARNING
            else:
                flag = CHECK_RESULT_PASS
        else:
            flag = CHECK_RESULT_PASS

    elif "V100R002C01" == curCVersion:
        if "V100R002C01SPC015" <= currentVer <= "V100R002C01SPCh00":
            if False == AlarmMask:
                flag = CHECK_RESULT_WARNING                      
        elif currentVer > "V100R002C01SPCh00":
            if True == AlarmMask:
                flag = CHECK_RESULT_WARNING
            else:
                flag = CHECK_RESULT_PASS
        else:
            flag = CHECK_RESULT_PASS                
            
    elif "V100R005C00" == curCVersion:
        if "V100R005C00SPC003" <= currentVer <= "V100R005C00SPC700":
            if False == AlarmMask:
                flag = CHECK_RESULT_WARNING      
        elif currentVer > "V100R005C00SPC700":
            if True == AlarmMask:
                flag = CHECK_RESULT_WARNING
            else:
                flag = CHECK_RESULT_PASS
        else:
            flag = CHECK_RESULT_PASS                
                
    elif "V100R005C01" == curCVersion:
        if "V100R005C01SPC100" <= currentVer <= "V100R005C01SPC700":
            if False == AlarmMask:
                flag = CHECK_RESULT_WARNING  
        elif currentVer > "V100R005C01SPC700":
            if True == AlarmMask:
                flag = CHECK_RESULT_WARNING
            else:
                flag = CHECK_RESULT_PASS
        else:
            flag = CHECK_RESULT_PASS                
    #性能转储巡检项优化 20130922 added begin
    elif curCVersion >= "V100R005C02":
        if True == AlarmMask:
            flag = CHECK_RESULT_WARNING
        else:
            flag = CHECK_RESULT_PASS
    else:
        flag = CHECK_RESULT_PASS            
    #性能转储巡检项优化 20130922 added end

    if CHECK_RESULT_WARNING == flag:   
        #未打开，建议打开
        if False == AlarmMask:
            if "zh" == lang:
                #性能转储巡检项优化 20130922 deleted
                errMsg += u"\n步骤1 以admin用户登录设备。"
                errMsg += u"\n步骤2 执行CLI命令 hw_chgalarmmask -i 60163817496 -m 1， 请等待执行完成后再重新检查一次。"
            else:
                #性能转储巡检项优化 20130922 deleted
                errMsg += "\nStep 1 Log in to the device as user admin."
                errMsg += "\nStep 2 Run the hw_chgalarmmask -i 60163817496 -m 1 command, wait until the command operates successfully and then perform a check."
        #已打开，建议关闭
        else:
            if "zh" == lang:
                #性能转储巡检项优化 20130922 deleted
                errMsg += u"\n步骤1 以admin用户登录设备。"
                errMsg += u"\n步骤2 执行CLI命令 hw_chgalarmmask -i 60163817496 -m 0， 请等待执行完成后再重新检查一次。"
            else:
                #性能转储巡检项优化 20130922 deleted
                errMsg += "\nStep 1 Log in to the device as user admin."
                errMsg += "\nStep 2 Run the hw_chgalarmmask -i 60163817496 -m 0 command, wait until the command operates successfully and then perform a check."
    else:
        errMsg = ""
                                        
    return (flag, cliRet, errMsg)

""" 性能转储巡检 20130709 added End """