# -*- coding: UTF-8 -*-

"""电源状态判断条件增加 added Begin"""
import re
"""电源状态判断条件增加 added End"""
import common
import hardware

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 电源状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    powerStatus = ""
    errMsg = ""
    
    cliRet = cli.execCmd("showpower")
    standardBomCode = ""
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."
        return (flag, cliRet, errMsg)
    
    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        # There are three kinds of status: Normal, No Input and Fault.
        # The status "No Input" is special(a space between the two words),
        # therefore it should be special treated. 
        """电源状态判断条件增加 added Begin"""
        if list2[2] in ["No", "Input", "Not", "I2C", "Voltage", "Switch"]:
            powerStatus = list2[2] + " " + list2[3]
        else:
            powerStatus = list2[2]
        """电源状态判断条件增加 added End"""
        standardBomCode = hardware.getNormalBomCodeByEncId(list2[0],"POWER",cliRet)
        bomCode = hardware.getHardwareBomCode([list2[0],list2[1]],"POWER",cliRet)
        if powerStatus != "Normal":
            flag = False
            if "zh" == lang:
                errMsg += u"\n电源（框ID：" + list2[0] + u"，电源ID：" + list2[1]\
                          + u"）状态不正常（" + powerStatus + u"）。"
                if bomCode:
                    errMsg += u"\n硬件（框ID：" + list2[0] + u"，电源ID：" + list2[1]\
                                      + u"）的BOM编码（" + bomCode + u"）。" 
                elif standardBomCode:
                    errMsg += u"\n无法获取硬件（框ID：" + list2[0] + u"，电源ID：" + list2[1]\
                          + u"）的BOM编码，同框正常硬件的BOM编码（" + standardBomCode + u"）。"  
                else:
                    errMsg += u"\n无法获取硬件（框ID：" + list2[0] + u"，电源ID：" + list2[1]\
                          + u"）的BOM编码。" 
                    
            else:
                errMsg += "\nThe status of power (enclosure-id:" + list2[0] + ", power-id:" \
                          + list2[1] + ") is abnormal(" + powerStatus + ")."
                if bomCode:
                    errMsg += u"\nBOM number of hardware(enclosure-id:" + list2[0] + u", power-id:" + list2[1]\
                                      + u"):" + bomCode + u"."
                elif standardBomCode: 									  
                    errMsg += u"\nCannot obtain the BOM number of the hardware (enclosure-id:" + list2[0]  + u", power-id: " +  list2[1]\
                                      + u"),BOM number of the normal hardware in same enclosure:" + standardBomCode + u"."  
                            
                else:
                    errMsg += u"\nCannot obtain the BOM number of the hardware(enclosure-id:" + list2[0]  + u", power-id: " +  list2[1]\
                                      + u")." 
    return (flag, cliRet, errMsg)