# -*- coding: UTF-8 -*-

import re
import common

CHECK_RESULT_PASS = "True"
CHECK_RESULT_NOTPASS = "False"
CHECK_RESULT_NOCHECK = "NOCHECK"
CHECK_RESULT_NOSUPPORT = "NOSUPPORT"
CHECK_RESULT_WARNING = "WARNING"

# **************************************************************************** #
#功能说明：获取Raid组数据列表
#输入参数：
#    cliRet4raidGroup：Raid组的cli回显信息
#返 回 值：Raid组数据列表
# **************************************************************************** #
def getRaidGroupDataList(cliRet4raidGroup):
    
    raidGroupDataList = []
    #没有创建Raid组
    list = cliRet4raidGroup.splitlines()
    if len(list) < 7:
        return raidGroupDataList
    
    cliRet4raidGroupList = cliRet4raidGroup.splitlines()
    for line in cliRet4raidGroupList[6:-3]:
        raidDataDict = {"ID":"", "Level":"", "Disk List":""}
        lineList = line.split()
        raidDataDict["ID"] = lineList[0]
        raidDataDict["Level"] = lineList[1]
        raidDataDict["Disk List"] = lineList[-2]
        raidGroupDataList.append(raidDataDict)
    return raidGroupDataList

# **************************************************************************** #
#功能说明：获取Pool数据列表
#输入参数：
#    cliRet4pool：Pool的cli回显信息
#返 回 值：Pool数据列表
# **************************************************************************** #
def getPoolDataList(cliRet4pool):
    
    poolDataList = []
    #没有创建Thin Pool
    list = cliRet4pool.splitlines()
    if len(list) < 7:
        return poolDataList

    cliRet4poolList = cliRet4pool.splitlines()
    for line in cliRet4poolList[6:-3]:
        poolDataDict = {"ID":"", "Level":"", "Disk List":""}
        lineList = line.split()
        poolDataDict["ID"] = lineList[0]
        poolDataDict["Level"] = lineList[2]
        poolDataDict["Disk List"] = lineList[-1]
        poolDataList.append(poolDataDict)
    return poolDataList

# **************************************************************************** #
#功能说明：获取硬盘物理信息数据字典
#输入参数：
#    cliRet4physicalDisk：硬盘物理信息的cli回显信息
#返 回 值：硬盘物理信息数据字典
# **************************************************************************** #
def getDiskPhysicalDataDict(cliRet4physicalDisk):
    
    diskPhysicalDataDict = {}
    #没有硬盘，返回空
    list = cliRet4physicalDisk.splitlines()
    if len(list) < 7:
        return diskPhysicalDataDict
    
    cliRet4physicalDiskList = cliRet4physicalDisk.splitlines()
    for line in cliRet4physicalDiskList[6:-3]:
        lineList = line.split()
        location = lineList[0]
        type = ''
        #获取硬盘物理类型
        if re.search('Off line|Single path|Write protect', line, re.IGNORECASE):  
            type = lineList[3]
        else:
            type = lineList[2]
            
        #获取硬盘物理Type:其中SATA与NL SAS可以互相作为热备盘，统一写成SATA"
        if type == 'NL':
            type = 'SATA'
            
        diskPhysicalDataDict[location] = type
        
    return diskPhysicalDataDict
            

# **************************************************************************** #
# 函数名称: execute
# 功能说明: Raid组配置检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    
    flag = True
    cliRet = ""
    errMsg = ""
        
    try:
        lang = py_java_env.get("lang")
        
        #执行命令获取回文
        cliRet4raidGroup = cli.execCmd("showrg")
        cliRet4pool = cli.execCmd("showpool")
        cliRet4physicalDisk = cli.execCmd("showdisk -physic")
        cliRet = cliRet4raidGroup + "\n" + cliRet4pool+ "\n" + cliRet4physicalDisk
        
        #获取RAID组数据列表
        raidGroupDataList = []
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet4raidGroup, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nRaid组信息无效。"
            else:
                errMsg = "\nRaid group information is invalid."
            return (flag, cliRet, errMsg)
        else:
            #存在Raid组，创建列表信息
            raidGroupDataList = getRaidGroupDataList(cliRet4raidGroup)
        
        #获取ThinPool数据列表
        poolDataList = []
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet4pool, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nThin Pool信息无效。"
            else:
                errMsg = "\nThin Pool information is invalid."
            return (flag, cliRet, errMsg)
        else:
            #存在ThinPool，创建列表信息
            poolDataList = getPoolDataList(cliRet4pool)
    
        #如果不存在Raid组和ThinPool，则返回通过
        if raidGroupDataList == [] and poolDataList == []:
            return (flag, cliRet, errMsg)
        
        #获取硬盘物理信息 
        diskPhysicalDataDict = {}
        list = cliRet4physicalDisk.splitlines()
        if len(list) < 7:
            flag = False
            if lang == "zh":
                errMsg = u"\n硬盘物理信息无效。"
            else:
                errMsg = "\nDisk physical information is invalid."          
            return (flag, cliRet, errMsg)
        else:
            diskPhysicalDataDict = getDiskPhysicalDataDict(cliRet4physicalDisk)
    
        #根据RAID组和硬盘物理信息数据判断
        for raidGroupDataDict in raidGroupDataList:
            #RAID1/RAID6/RAID10级别不需要判断
            if raidGroupDataDict["Level"] in ["RAID1", "RAID6", "RAID10"]:
                continue
            #初始化变量
            diskList = []
            raidGroupType = ""
            
            if raidGroupDataDict["Disk List"].endswith(";"):
                diskList = raidGroupDataDict["Disk List"][:-1].split(";")
            else:
                diskList = raidGroupDataDict["Disk List"].split(";")
            
            #检查盘的type是否全是“--”或空白
            for diskLocation in diskList:
                diskLocation = "(" + diskLocation + ")"
                if diskPhysicalDataDict.has_key(diskLocation):
                    type = diskPhysicalDataDict[diskLocation]
                    
                    if type in ["", "--"]:
                        continue
                    else:
                        raidGroupType = type
                        break
            #判断类型
            if "SATA" == raidGroupType:
                flag = CHECK_RESULT_WARNING
                if "zh" == lang:
                    errMsg += u"\nRAID组（RAID组ID：" + raidGroupDataDict.get("ID") + u"）由SATA盘/NL SAS盘构成，RAID组级别为" \
                        + raidGroupDataDict.get("Level") + u"，配置的可靠性不高。"
                else:
                    errMsg += "\nRAID group (raid-group-id:" + raidGroupDataDict.get("ID") + ") consists of SATA/NL SAS disk, RAID group level is " \
                        + raidGroupDataDict.get("Level") + ", the reliability of its configuration is not enough."
            elif "" == raidGroupType:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nRAID组（RAID组ID：" + raidGroupDataDict.get("ID") + u"）无法查询到盘类型。"
                else:
                    errMsg += "\nCan not get the disk type of RAID group (raid-group-id:" + raidGroupDataDict.get("ID") + ")."
                            
        #根据Pool和硬盘物理信息数据判断
        for poolDataDict in poolDataList:
            #RAID1/RAID6/RAID10级别不需要判断
            if poolDataDict.get("Level") in ["RAID1", "RAID6", "RAID10"]:
                continue
            #初始化变量
            diskList = []
            poolType = ""
            if poolDataDict.get("Disk List").endswith(";"):
                diskList = poolDataDict.get("Disk List")[:-1].split(";")
            else:
                diskList = poolDataDict.get("Disk List").split(";")
            
            #检查盘的type是否全是“--”或空白
            for diskLocation in diskList:
                diskLocation = "(" + diskLocation + ")"
                if diskPhysicalDataDict.has_key(diskLocation):
                    type = diskPhysicalDataDict.get(diskLocation)
                    
                    if type in ["", "--"]:
                        continue
                    else:
                        poolType = type
                        break
            #判断类型
            if "SATA" == poolType:
                flag = CHECK_RESULT_WARNING
                if "zh" == lang:
                    errMsg += u"\n精简池（精简池ID：" + poolDataDict.get("ID") + u"）由SATA盘/NL SAS盘构成，RAID级别为" \
                        + poolDataDict.get("Level") + u"，配置的可靠性不高。"
                else:
                    errMsg += "\nThin Pool (thin-pool-id:" + poolDataDict.get("ID") + ") consists of SATA/NL SAS disk, RAID level is " \
                        + poolDataDict.get("Level") + ", the reliability of its configuration is not enough."
            elif "" == poolType:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n精简池（精简池ID：" + poolDataDict.get("ID") + u"）无法查询到盘类型。"
                else:
                    errMsg += "\nCan not get the disk type of Thin Pool (thin-pool-id:" + poolDataDict.get("ID") + ")."
    
        return (flag, cliRet, errMsg)
    except BaseException, be:
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询失败。"
        else:
            errMsg = "\nQuery failed."
        return (flag, cliRet, errMsg)