# -*- coding:utf-8 -*-
import re
import common
import traceback
from comm.cTV1R1 import ParseException
from comm.cTV1R1 import parseHorizontal
from common import getParseExceptErrMsg
WARNING = 'WARNING'


def execute(ssh):
    '''
    Function name        :execute(ssh)
    Function describe    :execute item check
    Input                :Cli--Telnet access proxy
    Return               :flag、 cliRet、 errMsg
    '''
    
    #初始化变量
    errMsg = ""
    cliRet = ""
    lang = py_java_env.get("lang")
    
    #获取开启休眠功能的RAID组ID
    sleepFlag, allRaidGroupId, allThinPoolId, sleepCliRet, sleepErrMsg = getSpindownID(ssh, lang)
    cliRet += '\n' + sleepCliRet
    
    if not sleepFlag:
        #获取休眠信息失败
        return (False, cliRet, sleepErrMsg)
    elif not allRaidGroupId and not allThinPoolId:
        #没有开启休眠功能
        return (True, cliRet, sleepErrMsg)
    else:
        #将所有休眠的RAID组排序    begin
        if allRaidGroupId:
            allRaidGroupId.sort(cmp_str)
        if allThinPoolId:
            allThinPoolId.sort(cmp_str)
        #将所有休眠的RAID组排序    end
        
        #获取当前系统版本
        sysFlag, curSysVersion, sysVersionInfo, sysErrMsg = common.getCurSystemVersion(ssh, lang)
        cliRet += '\n' + sysVersionInfo
        #获取系统版本失败
        if not sysFlag:
            return (False, cliRet, sysErrMsg)
        
        if curSysVersion >= 'V100R005C30SPC100':
            return (True, cliRet, errMsg)
        elif curSysVersion == 'V100R005C02SPC300':
            #获取当前已安装的补丁版本
            patchFlag, curPatchVersion, hotPatchVerInfo, patchErrMsg = common.getCurHotPatchVersion(ssh, lang)
            cliRet += '\n' + hotPatchVerInfo
            #获取热补丁版本失败
            if not patchFlag:
                return (False, cliRet, patchErrMsg)
            
            #当前热补丁版本是V100R005C02SPH301，检查通过
            if 'V100R005C02' in curPatchVersion and curPatchVersion >= 'V100R005C02SPH301':
                return (True, cliRet, errMsg)
            else:
                #系统版本为’V100R005C02SPC300‘，没有打热补丁
                if lang == 'zh':
                    errMsg += (u'\n系统未安装V100R005C02SPH301或之后版本的热补丁。'
                               + getErrMsg(allRaidGroupId, allThinPoolId, lang)
                               + u'\n长时间运行后，存在系统单控复位的风险。')
                else:
                    errMsg += ('\nHot patch V100R005C02SPH301 or later has not been installed.'
                               + getErrMsg(allRaidGroupId, allThinPoolId, lang)
                               + '\nWhich may expose the system to single-controller reset risks after long-term running.')
                return (WARNING, cliRet, errMsg)
        else:
            #软件版本小于V100R005C30SPC100，且不为V100R005C02SPC300
            if lang == 'zh':
                    errMsg += (u'\n系统软件版本过低。'
                               + getErrMsg(allRaidGroupId, allThinPoolId, lang)
                               + u'\n长时间运行后，存在系统单控复位的风险。')
            else:
                errMsg += ('\nSystem software version is too low.'
                           + getErrMsg(allRaidGroupId, allThinPoolId, lang)
                           + '\nWhich may expose the system to single-controller reset risks after long-term running.') 
                
            return (WARNING, cliRet, errMsg)
# *********************************************
# 函数名称： getSpindownID
# 功能说明： 查看开启休眠功能的RAID GROUP ID和POOL ID
# 其他 ： 无
# *********************************************
def getSpindownID(ssh, lang):
    sleepErrMsg = ""
    allRaidGroupId = []
    allThinPoolId = []
    
    #输入命令，获取回显
    rgIoCliRet = ssh.execCmd('showrgiospindown')
    rgPrdCliRet = ssh.execCmd('showrgprdspindown')
    poolIoCliRet = ssh.execCmd('showpooliospindown')
    poolPrdCliRet = ssh.execCmd('showpoolprdspindown')
    
    cliRet = rgIoCliRet + '\n' + rgPrdCliRet + '\n' + poolIoCliRet + '\n' + poolPrdCliRet    
    #判断回显信息有效性
    if (not common.checkCliInfoValid(rgIoCliRet, False) 
        or not common.checkCliInfoValid(rgPrdCliRet, False)
        or not common.checkCliInfoValid(poolIoCliRet, False)
        or not common.checkCliInfoValid(poolPrdCliRet, False)):
        if lang == "zh":
            sleepErrMsg = u"\nCLI信息无效。"
        else:
            sleepErrMsg = "\nInvalid CLI information." 
        return (False, allRaidGroupId, allThinPoolId, cliRet, sleepErrMsg)
    
    #调用公有接口解析回文
    try:
        rgiospindownDictList = parseHorizontal(rgIoCliRet).getResult()
        rgprdspindownDictList = parseHorizontal(rgPrdCliRet).getResult()
        pooliospindownDictList = parseHorizontal(poolIoCliRet).getResult()
        poolprdspindownDictList = parseHorizontal(poolPrdCliRet).getResult()
    except ParseException, e:
        PY_LOGGER.error("[RAIDSpindownCausingMemoryLeak] except trace back:" + unicode(traceback.format_exc()))
        return (False, allRaidGroupId, allThinPoolId, cliRet , getParseExceptErrMsg(lang))

    #获取打开休眠命令的RAID GROUP ID
    for rgiospindownDict in rgiospindownDictList:
        allRaidGroupId.append(rgiospindownDict.get('Raid Group Id'))
        
    for rgprdspindownDict in rgprdspindownDictList:
        allRaidGroupId.append(rgprdspindownDict.get('Raid Group Id'))
        
    for pooliospindownDict in pooliospindownDictList:
        #部分版本中Idle Time(S)显示为"--"时表示未开启休眠  Begin
        if pooliospindownDict.get('Idle Time(S)', "").isdigit():
            allThinPoolId.append(pooliospindownDict.get('Pool Id'))
        #部分版本中Idle Time(s)显示为"--"时表示未开启休眠  End
        
    for poolprdspindownDict in poolprdspindownDictList:
        allThinPoolId.append(poolprdspindownDict.get('Pool Id'))
    #打开休眠功能的Id
    allRaidGroupId = list(set(allRaidGroupId))
    allThinPoolId = list(set(allThinPoolId))
        
    return (True, allRaidGroupId, allThinPoolId, cliRet, sleepErrMsg)

def getErrMsg(allRaidGroupId, allThinPoolId, lang):
    errMsg = ""
    if lang == 'zh':
        if allRaidGroupId:
            errMsg += u'\nRAID组（RAID Group ID：' + u"，".join(allRaidGroupId) + u'）已开启休眠功能。'
        if allThinPoolId:
            errMsg += u'\nThin pool（Pool ID：' + u"，".join(allThinPoolId) + u'）已开启休眠功能。' 
            
    else:
        if allRaidGroupId:
            errMsg += '\nThe sleep function has been enabled for RAID group(RAID Group ID: ' + u", ".join(allRaidGroupId) + ').'
        if allThinPoolId:
            errMsg += '\nThe sleep function has been enabled for thin pool(Pool ID: ' + u", ".join(allThinPoolId) + u').' 
            
    return errMsg

#将所有休眠的RAID组排序    begin
# *********************************************
# 函数名称： cmp_str
# 功能说明： 重写sort函数的cmp参数
# 其他 ： 无
# *********************************************
def cmp_str(str1, str2):
    if int(str1) > int(str2):
        return 1
    return -1
#将所有休眠的RAID组排序    end