# -*- coding: UTF-8 -*-

import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: Raid组休眠状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):

    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""

    #查询Raid组定时休眠信息
    cliRetTmp1 = cli.execCmd("showrgprdspindown")
    cliRet += cliRetTmp1 + "\n"
    list = cliRetTmp1.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRetTmp1, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
            return (flag, cliRet, errMsg)

    #查询Raid组不定时休眠信息
    cliRetTmp2 = cli.execCmd("showrgiospindown")
    cliRet += cliRetTmp2 + "\n"
    list = cliRetTmp2.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRetTmp2, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
            return (flag, cliRet, errMsg)
    
    #检查信息返回
    return (flag, cliRet, errMsg)

"""P11G-5580 Raid组休眠状态巡检项增加 20121204 added End"""