# -*- coding: UTF-8 -*-

import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 资源池信息检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    usage = 0
    threadshold = 0

    cliRet = cli.execCmd("showrespool")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 3:
            continue
        if float(list2[1]) > 0.0:
            usage = int(float(list2[2]) / float(list2[1]) * 100)
            threadshold = int(list2[4])
            if usage >= threadshold:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n资源池（资源池ID：" + list2[0] + u"）的使用率是" + unicode(usage)\
                              + u"%，超过了临界值" + unicode(threadshold) + u"%。"
                else:
                    errMsg += "\nThe usage(" + unicode(usage) + "%) of the resource pool (pool-id:" + list2[0]\
                              + ") is larger than alarm threshold(" + unicode(threadshold) + "%)."

    return (flag, cliRet, errMsg)
