# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 智能缓存池信息检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""    
    poolID = ""
    total = 0.0
    consumed = 0.0
    avail = 0.0

    cliRet = cli.execCmd("showsmtcpool")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."          
        return (flag, cliRet, errMsg)    
    
    for field in list:
        field = field.replace(" ", "").replace("|", "")
        
        if field.startswith("SmartCachePoolID"):
            poolID = field.replace("SmartCachePoolID", "")
        elif field.startswith("TotalCapacity(MB)"):
            total = float(field.replace("TotalCapacity(MB)", ""))
        elif field.startswith("ConsumedCapacity(MB)"):
            consumed = float(field.replace("ConsumedCapacity(MB)", ""))
        elif field.startswith("AvailableCapacity(MB)"):
            avail = float(field.replace("AvailableCapacity(MB)", ""))
            if total != (consumed + avail):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n智能缓存池（智能缓存池ID：" + poolID + u"）的总容量（" + unicode(total) + u"MB）不等于可用容量（"\
                              + unicode(avail) + u"MB）和使用容量（" + unicode(avail) + u"MB）之和。"
                else:
                    errMsg += "\nTotal capacity (" + unicode(total) + "MB) of smart cache pool (smart-cache-pool-id:" + poolID\
                              + ") is not equal to the sum of available capacity ("\
                              + unicode(avail) + "MB) and consumed capacity (" + unicode(consumed) + "MB)."

    return (flag, cliRet, errMsg)
