# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 分裂镜像检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    mirrorlist = []

    cliRet = cli.execCmd("showmirror")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."           
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 2:
            continue
        mirrorlist.append(list2[1])

    for mirrorid in mirrorlist:
        cliRet2 = cli.execCmd("showsecluninmirror -mirror " + mirrorid)
        cliRet += cliRet2
        list3 = cliRet2.splitlines()
        if len(list3) < 7:
            if not common.checkCliInfoValid(cliRet2, False):
                flag = False
                if lang == "zh":
                    errMsg += u"\nCli信息无效(分裂镜像ID：" + mirrorid + u")。"
                else:
                    errMsg += "\nInvalid Cli information (mirror-id: " + mirrorid + ")." 
            continue
    
        for field2 in list3[6:]:
            list4 = field2.split()
            if len(list4) < 4:
                continue
            if list4[3] in ("Interrupted", "Fault", "To"):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n分裂镜像（分裂镜像ID：" + mirrorid + u"）的Pair " + list4[2] + u"存在异常。"
                else:
                    errMsg += "\nThe status of pair " + list4[2] + " of mirror (mirror-id:"\
                              + mirrorid + ") is abnormal(" + list4[3] + ")."
                              
    return (flag, cliRet, errMsg)