# -*- coding: UTF-8 -*-
import re
from comm import modelManager
from common import getCurSystemVersion
from comm.cTV1R1 import ParseException

def execute(cli):
    """
    Create date        : 2015/03/24
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    errMsg = ""
    cliRet = ""
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
        
    flag, sysSpcVersion, cliRet1, errMsg = getCurSystemVersion(cli, lang)
    cliRet += cliRet1
    if not flag:
        return (flag, cliRet, errMsg)
    
    if not (("V100R001C00" in sysSpcVersion and sysSpcVersion <= "V100R001C00SPC015")
        or ("V100R001C01" in sysSpcVersion and sysSpcVersion <= "V100R001C01SPC015")
        or ("V100R002C00" in sysSpcVersion and sysSpcVersion <= "V100R002C00SPC005")
        or (sysSpcVersion == "V100R002C01SPC001")):
        return (True, cliRet, errMsg)
    
    if not modelManager.changeCli2Debug(cli, py_java_env):
        logger.warn("[SystemResetEvery208Days]Login to debug model failed.")
        if lang == "zh":
            errMsg += (u"\n进入debug模式失败，失败的原因可能为：" 
                       + u"\n（1）添加设备时未输入调试密码。"
                       + u"\n（2）添加设备时输入的调试密码无效。")
        else:
            errMsg += ("\nLog in to debug model failed, the reason of failure may be:" 
                       + "\n(1) Did not enter a debug password when adding the device."
                       + "\n(2) The debug password entered is incorrect.")
        return (False, cliRet, errMsg)
    
    try:      
        cliRet2 = cli.execCmd("find /startup_disk/image/boot/ -name sched.pat")
        cliRet += "\n" + cliRet2
        
        if "/startup_disk/image/boot/sched.pat" in cliRet2:
            return (True, cliRet, errMsg)
        else:
            if "zh" == lang:
                errMsg += u"\n系统连续运行208天后，存在系统复位的风险。"
            else:
                errMsg += "\nThe system is exposed to reset risks after running consecutively for 208 days."
            
            #检查本端系统运行时间
            localflag, localcliRet, localchkInfo = chkUptimeInfo(cli, lang, isLocal=True)
            flag = localflag
            cliRet += "\n" + localcliRet
            errMsg += localchkInfo
            
            #尝试切换到对端，检查对端系统运行时间，如果切换对端失败，忽略对端结果
            if modelManager.linkCtrlByHeartBeat(cli):
                peerflag, peercliRet, peerchkInfo = chkUptimeInfo(cli, lang, isLocal=False)
                
                cli.execCmd("exit") #返回本端
                
                if flag == "WARNING":
                    flag = peerflag
                cliRet += "\n" + peercliRet
                errMsg += peerchkInfo
            
        return flag, cliRet, errMsg
    
    finally:
        modelManager.changeAnyModel2Cli(cli)      


def chkUptimeInfo(cli, lang, isLocal=True):
    """
    Create date        : 2015/05/27
    Function describe  : query the system running period
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass; cli source info;system running period; 
    """
    flag = "WARNING"
    cliRet = cli.execCmd("uptime")
    chkInfo = ""
    
    matcher = re.match("(.|\s)*up\s*(\d+)\s*(day)?(.|\s)*", cliRet)
    if not matcher:
        PY_LOGGER.error("[SystemResetEvery208Days]Failed to query system running period")
        flag = False
        if "zh" == lang:
            chkInfo += (u"\n本端" if isLocal else u"\n对端") + u"控制器：查询系统运行天数失败。"
        else:
            chkInfo += ("\nLocal" if isLocal else "\nPeer") + " controller: Failed to query the number of days for which the system has been running."
    else:
        days = int(matcher.group(2)) if matcher.group(3) else 0
        PY_LOGGER.info("[SystemResetEvery208Days]the number of days for which the system has been running: " + unicode(days))
        
        flag = "WARNING" if days < 180 else False
        if "zh" == lang:
            chkInfo += (u"\n本端" if isLocal else u"\n对端") + u"控制器：系统当前已连续运行" + unicode(days) + u"天。"
        else:
            chkInfo += ("\nLocal" if isLocal else "\nPeer") + " controller: The system has been running consecutively for " + unicode(days) + (" days." if days > 1 else " day.")
        
    return flag, cliRet, chkInfo
