# -*- coding: UTF-8 -*-
import re 
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 系统状态检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showsys")
    list = cliRet.splitlines()
    
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"Cli信息无效。"
            else:
                errMsg = "Invalid Cli information."
        return (flag, cliRet, errMsg)   
    
    for field in list:
        if field.startswith("  Current System Mode"):
            if "Normal" not in field:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n系统运行存在异常（" + field[field.index("|") + 2:].strip() + u"）。"
                else:
                    errMsg += "\nThe system runs abnormally(" + field[field.index("|") + 2:].strip()\
                              + ")."

    return (flag, cliRet, errMsg)