# -*- coding: UTF-8 -*-
import common
from comm.cTV1R1 import *
WARNING = 'WARNING'

def _isNoRiskVer(sysSpcVersion):
    if "V100R002" in sysSpcVersion:
        return False
    elif "V100R005C00" in sysSpcVersion:
        return False
    elif "V100R005C01" in sysSpcVersion:
        return False
    elif "V100R005C02" in sysSpcVersion:
        return False
    elif "V100R005C30" in sysSpcVersion and sysSpcVersion < "V100R005C30SPC500":
        return False
    else:
        return True
    
# **************************************************************************** #
# 函数名称: execute
# 功能说明: ThinLun信息检查
# 输入参数: ssh连接
# **************************************************************************** # 
def execute(ssh):
    errMsg = ""
    cliRet = ""
    lang = py_java_env.get("lang")
    
    #检查系统版本是否满足要求
    sysQryFlag, sysSpcVersion, cliRetSys, errMsgSys = common.getCurSystemVersion(ssh, lang)      
    cliRet = cliRetSys
    if not sysQryFlag:
        #查询系统版本失败
        return (sysQryFlag, cliRet, errMsgSys)
    
    #避免设备升级未更新，检查项不通过
    if _isNoRiskVer(sysSpcVersion):
        return (True, cliRet, "")
    
    #阵列软件版本与热补丁版本对应关系
    verDict = {'V100R005C00SPC900' : 'V100R005C00SPH903', 'V100R005C01SPC900' : 'V100R005C01SPH903'}
    
    #V100R005C00SPC900版本，安装了SPH903补丁巡检通过
    if sysSpcVersion in verDict:
        #获取当前热补丁版本号
        patchQryFlag, curHotPatchVer, cliRetPatch, errMsgPatch = common.getCurHotPatchVersion(ssh, lang)  
        cliRet += "\n" + cliRetPatch
        if not patchQryFlag:
            #获取热补丁信息失败
            return (patchQryFlag, cliRet, errMsgPatch)
        #补丁为空或存在
        if curHotPatchVer >= verDict.get(sysSpcVersion):
            return (True, cliRet, "")
        
        
    iRet = ssh.execCmd("showlun")
    cliRet += '\n' + iRet
    cliList = iRet.splitlines()
    if len(cliList) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(iRet, False):
            zhErrMsg = u"\nCLI信息无效。"
            enErrMsg = "\nInvalid CLI information."   
            errMsg = common.selectErrorMsg(lang, zhErrMsg, enErrMsg)      
            return (False, cliRet, errMsg)  
        #showlun没有LUN时，小于7行但是有效的
        return (True, cliRet, "")      
     
    try:   
        listDictLun = parseHorizontal(iRet).getResult()
    except ParseException:
        PY_LOGGER.error("[ThinLUNFull]ParseException: " + unicode(traceback.format_exc()))
        return(False, cliRet, common.getParseExceptErrMsg(lang))
    
    #判断是否存在容量大于60G的ThinLun
    thinLunFullList = []
    for dictInfo in listDictLun:
        if unicode(dictInfo.get('Lun Type')).upper() == 'THIN' and float(dictInfo.get('Visible Capacity(Mb)')) >= 61440.0:
            iRetEachThin = ssh.execCmd("showlun -lun %s" % dictInfo.get('Id'))
            cliRet += '\n' + iRetEachThin
            cliList = iRetEachThin.splitlines()
            if len(cliList) < 7:
                #判断cli信息是否有效
                if not common.checkCliInfoValid(iRetEachThin, False):
                    zhErrMsg = u"\n执行showlun -lun %s 命令时，CLI信息无效。" % dictInfo.get('Id')
                    enErrMsg = "\nThe CLI information is invalid when runing showlun -lun %s." % dictInfo.get('Id')   
                    errMsg = common.selectErrorMsg(lang, zhErrMsg, enErrMsg)      
                    #多个ThinLun信息都要查看
                    return (False, cliRet, errMsg)
                continue
            
            #计算ThinLun是否即将写满 
            try:
                listThinLun = parseVertical(iRetEachThin).getResult()
            except ParseException:
                PY_LOGGER.error("[ThinLUNFull]ParseException: " + unicode(traceback.format_exc()))
                return(False, cliRet, common.getParseExceptErrMsg(lang))
            
            for dictThinLun in listThinLun:
                if  float(dictThinLun.get('Consumed Capacity(Mb)')) + 2048.0 > float(dictThinLun.get('Visible Capacity(Mb)')):
                    thinLunFullList.append(dictInfo.get('Id'))
                    
    
    if thinLunFullList:
        if sysSpcVersion in verDict:
            zhVerErrMsg = u"\n系统未安装%s热补丁。" % verDict.get(sysSpcVersion)
            enVerErrMsg = "\nHot patch %s is not installed on the system."  % verDict.get(sysSpcVersion)
        else:
            zhVerErrMsg = u"\n系统软件版本过低。" 
            enVerErrMsg = "\nThe system software version is too low."
        zhErrMsg = zhVerErrMsg + u"\nThin LUN（LUNID:%s）即将写满，其空间分配满后，会低概率出现业务中断的风险。" % u','.join(thinLunFullList)
        enErrMsg = enVerErrMsg + "\nThin LUN(LUNID:%s)is nearly full. When the thin LUN is full, there is a low probability that service interruption occurs."  % ','.join(thinLunFullList)
        errMsg = common.selectErrorMsg(lang, zhErrMsg, enErrMsg) 
        return (WARNING, cliRet, errMsg)
    else:
        return (True, cliRet, "")
        

    
    
