# -*- coding: UTF-8 -*-

import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: 版本信息收集
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):

    # 1, 2, 3分别代表SYS包、冷补丁包和热补丁包
    pkgTypes = [1, 2, 3]
    cliRet = ""
    errMsg = ""
    lang = py_java_env.get("lang")
    
    for pkgType in pkgTypes:
        # 构造查询版本命令
        cmd = "showupgradepkginfo -t " + unicode(pkgType)
        cliRetTmp = cli.execCmd(cmd)
        cliRet += cliRetTmp + "\n"
        
        lines = cliRetTmp.splitlines()
        #系统版本必须检查回文有效性
        if pkgType == 1 and len(lines) < 7:
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information." 
            return (False, cliRet, errMsg)
        else:
            continue
    
    # 只查询版本号，检查项总是成功，失败信息总为空
    return (True, cliRet, errMsg)