# -*- coding: UTF-8 -*-

import re 
import common

"""Wifi模块功能巡检 20121204 added Begin"""
# **************************************************************************** #
# 函数名称: execute
# 功能说明: Wifi模块功能巡检
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """
    admin:/>showwifi 
    ===============================================================================
                                   Wi-Fi Information
    -------------------------------------------------------------------------------
      Status           | Signal Close
      Link Status      | Link Down
      SSID             | XX@210235G6T8Z0C3000005
      Silent Time      | 10
      Channel          | 1
      Ip Address       | xxx
      Ip Mask          | xxx
      GateWay          | xxx
      Electronic Label | /$[ArchivesInfo Version]
                       | /$ArchivesInfoVersion=3.0
                       |  
                       |  
                       | [Board Properties]
                       | BoardType=STL1EARD
                       | BarCode=02G34N1234567890
                       | Item=0302G34N
                       | Description=PANGEA,STL1EARD,WIFI  Auxiliary Card,V100R005,10*1
                       | Manufactured=2012-11-19
                       | VendorName=
                       | IssueNumber=00
                       | CLEICode=
                       | BOM=
    ==============================================================================="""

    flag = True
    WifiModuleStatus = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showwifi")

    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."            
        return (flag, cliRet, errMsg)

    WifiModuleStatus = (list[4].replace(" ", "").split("|"))[1]
    
    if WifiModuleStatus in ["Fault", "--"]:
        flag = False
        if "zh" == lang:
            errMsg += u"\nWifi功能状态存在异常。"
        else:
            errMsg += u"\nThe status of Wifi module is abnormal."

    return (flag, cliRet, errMsg)

"""Wifi模块功能巡检 20121204 added End"""