# -*- coding: UTF-8 -*-

import traceback
import common
import re
from comm import modelManager

PY_JAVA_ENV = py_java_env


# **************************************************************************** #
# 函数名称: execute
# 功能说明: 空闲内存检查
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** #
def execute(cli):
    """
        空闲内存检查
    """
    lang = PY_JAVA_ENV.get("lang")
    logger = PY_LOGGER
    sftp = PY_JAVA_ENV.get("sftp")
    allRet = ""
    freeMemCmd = "free -m"
    minFreeMem = 150
    try:
        common.refreshProcess(PY_JAVA_ENV, 5, logger)
        devNode = PY_JAVA_ENV.get("devInfo")
        usrPwd = devNode.getLoginUser().getPassword()

        freeMemA, flag, cliRet, errMsg  = getFreeMemInCtrl(cli, sftp, freeMemCmd, lang)
        allRet += '\n' + cliRet
        if flag != True:
            return flag, allRet, errMsg

        # 和需求提出人对齐的方案，如果存在单控模式，心跳失败也是报未完成检查。
        flag, cliRet = modelManager.linkCtrlInMinisystem(cli, usrPwd)
        del usrPwd
        allRet += '\n' + cliRet
        if flag != True:
            return common.RESULT_NOCHECK, allRet, common.getMsg(lang, "free.memory.lower.mem.heartbeat.failed")

        freeMemB, flag, cliRet, errMsg = getFreeMemInCtrl(cli, sftp, freeMemCmd, lang)
        allRet += '\n' + cliRet
        if flag != True:
            return flag, allRet, errMsg

        if int(freeMemA) < minFreeMem and int(freeMemB) < minFreeMem:
            return False, allRet, common.getMsg(lang, "free.memory.lower.mem.not.pass", (freeMemA, freeMemB))

        if int(freeMemA) < minFreeMem or int(freeMemB) < minFreeMem:
            tmpMem = freeMemA if int(freeMemA) < minFreeMem else freeMemB
            return common.RESULT_WARNING, allRet, common.getMsg(lang, "free.memory.lower.mem.warning", tmpMem)

        return True, allRet, ''
    except Exception, exception:
        logger.error("traceback:" + str(traceback.format_exc()))
        return (common.RESULT_NOCHECK, allRet, common.getMsg(lang, "free.memory.lower.mem.get.info.failed"))
    finally:
        modelManager.changeAnyModel2Cli(cli, sftp)
        common.refreshProcess(PY_JAVA_ENV, 100, logger)


def getFreeMemInCtrl(cli, sftp, freeMemCmd, lang):
    allRet = ''
    freeMemA = ''
    flag, cliRet = modelManager.changeCli2DeveloperWithCliRet(cli, PY_JAVA_ENV)
    allRet += cliRet
    if flag != True:
        return freeMemA, common.RESULT_NOCHECK, allRet, common.getMsg(lang, "free.memory.lower.mem.goto.developer.failed")

    # 和需求提出人对齐的方案，可能存在进入minisystem失败的场景，报未完成检查。
    flag, cliRet = modelManager.changeDeveloper2MinisystemWithCli(cli, sftp)
    allRet += cliRet
    if flag != True:
        return freeMemA, common.RESULT_NOCHECK, allRet, common.getMsg(lang, "free.memory.lower.mem.goto.minisystem.failed")

    cliRet = cli.execCmd(freeMemCmd)
    allRet += cliRet
    freeMemA = getFreeMem(cliRet)
    if not freeMemA:
        return freeMemA, common.RESULT_NOCHECK, allRet, common.getMsg(lang, "free.memory.lower.mem.get.info.failed")

    return freeMemA, True, allRet, ""

def getFreeMem(cliRet):
    freeMem = None
    regRexTitle = re.compile(r"total\s+used\s+free\s+.*?", re.IGNORECASE)
    if regRexTitle.findall(cliRet):
        regRex = re.compile(r"Mem:\s+\d+\s+\d+\s+(\d+)\s+.*?", re.IGNORECASE)
        res = regRex.findall(cliRet)
        if res:
            freeMem = res[0]

    if not freeMem:
        tmpLines = cliRet.splitlines()
        freeIndex = 0
        for line in tmpLines:
            tmpLowerLine = line.lower()
            if "total" in tmpLowerLine and "free" in tmpLowerLine:
                tmpList = tmpLowerLine.split()
                for tmpEle in tmpList:

                    if "free" == tmpEle:
                        break

                    freeIndex += 1

            if "mem:" in tmpLowerLine:
                tmpResLines = tmpLowerLine.replace("mem:", "").split()
                if not len(tmpResLines) > freeIndex:
                    continue

                freeMem = tmpResLines[freeIndex]
                break

    return freeMem
