# -*- coding: UTF-8 -*-

"""P11G-5580 iscsi链路速率 20121204 added Begin"""
import re
import common

# **************************************************************************** #
# 函数名称: execute
# 功能说明: iSCSI链路速率巡检
# 输入参数: cli
# 输出参数: 无
# 返 回 值: flag, cliRet, errMsg
# **************************************************************************** # 
def execute(cli):
    """admin:/>showiscsispeed
    ========================================================================================
                                        iSCSI Port Speed
    ----------------------------------------------------------------------------------------
      Controller ID    Interface Module ID    Port ID    Current Speed                      
    ----------------------------------------------------------------------------------------
      A                0                      P0         --                                 
      A                0                      P1         --                                                                 
      A                1                      H4         1000Mbps, Full Duplex, Autoneg ON  
      A                1                      H5         --                                                               
      B                1                      H3         --                                 
      B                1                      H4         1000Mbps, Full Duplex, Autoneg ON  
      B                1                      H5         --                                 
    ========================================================================================"""
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    curspeedtemp = ""
    lang = py_java_env.get("lang")
    errMsg = ""

    cliRet = cli.execCmd("showiscsispeed")
    list = cliRet.splitlines()
    if len(list) < 7:
        #判断cli信息是否有效
        if not common.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\nCli信息无效。"
            else:
                errMsg = "\nInvalid Cli information."           
        return (flag, cliRet, errMsg)

    for field in list[6:]:
        list2 = field.split()
        if len(list2) < 4:
            continue
        #P11A-7819 10Gbps速率显示修改 modified 20130218 Begin
        if list2[3] not in ("--", "1000Mbps,", "10Gbps,"):
            curspeedtemp = unicode(field[field.index(list2[3]):]).strip()
            flag = False
            if "zh" == lang:
                errMsg += u"\niSCSI端口（控制器ID：" + list2[0] + u"，接口模块ID：" + list2[1] \
                        + u"，端口ID：" + list2[2] + u"）速率存在异常（" + curspeedtemp + u"）。"
            else:
                errMsg += "\nThe iSCSI port rate (controller-id:" + list2[0] + ", interface-module-id:" \
                        + list2[1] + ", port-id:" + list2[2] + ") is abnormal(" + curspeedtemp + ")."
        #P11A-7819 10Gbps速率显示修改 modified 20130218 End

    return (flag, cliRet, errMsg)

"""P11G-5580 iSCSI链路速率 20121204 added End"""