# -*- coding: UTF-8 -*-
import os
import re
import traceback
import time
        
#一键收集日志命令超时时间（25分钟）
COLLECT_CMD_TIMEOUT = 25 * 60

def getDataCollectDecompressDir(java_env, ssh, logger):
    '''
    @summary: 获取一键收集日志的解压目录
    @param dataDict: the context object provided by tool framework
    @return: flag, dataCollectRet, errMsg, deCompressDestDir
    '''
    flag = True
    dataCollectRet = ''
    errMsg = ''
    deCompressDestDir = ""
    
    dataCollectTmpDir = java_env.get("dataCollectTmpDir")
    if not dataCollectTmpDir:
        devNode = java_env.get("devInfo")
        dataCollectTmpDir = 'pytemp' + os.sep + devNode.getDeviceSerialNumber() + "_" + time.strftime('%Y%m%d%H%M%S', time.localtime(time.time())) + os.sep 
        java_env['dataCollectTmpDir'] = dataCollectTmpDir
    logger.info("dataCollectTmpDir:" + unicode(dataCollectTmpDir))
    
    sftp = java_env.get("sftp")
    lang = java_env.get("lang")
    
    #执行收集前，先删除阵列旧日志：/OSM/export_import/Datacollect_*.tgz
    remoteLogFile = "/OSM/export_import/Datacollect_*.tgz"
    try:
        #获取即将被删除的文件列表,并删除
        willRmFiles = sftp.listFiles(remoteLogFile)
        sftp.deleteFile(remoteLogFile)
        logger.info("success to delete %s" % ", ".join(willRmFiles))
    #删除异常不影响正常流程，仅记录日志 
    except:
        logger.error("Failed to delete /OSM/export_import/Datacollect_*.tgz. except trace back:" + unicode(traceback.format_exc()))
    
    #需要执行一键收集日志（设置超时时间25分钟）
    dataCollectRet = ssh.execCmdWithTimout("datacollect", COLLECT_CMD_TIMEOUT)
    if re.search("The system is busy", dataCollectRet, re.IGNORECASE):
        if lang == "zh":
            errMsg = u"未成功收集日志，请等待5分钟后重试。如果重试仍然收集失败，请联系技术支持工程师协助处理。"
        else:
            errMsg = "Logs are not successfully collected. Please wait for five minutes and try again. If log collection still fails, contact technical support engineers."
        return (False, dataCollectRet, errMsg, deCompressDestDir)
    
    #命令执行失败
    if not re.search("Path :", dataCollectRet, re.IGNORECASE):
        if lang == "zh":
            errMsg = u"收集系统日志失败。"
        else:
            errMsg = "Failed to collect system log."
        return (False, dataCollectRet, errMsg, deCompressDestDir)
        
    #步骤3：获取远程文件路径
    remotePath = ""
    remoteFileName = ""
    lineList = dataCollectRet.splitlines()
    
    #获取远端阵列上的临时文件全路径
    for line in lineList:
        if line.find("Path :") != -1:
            lineSub = line[line.index("Path :"):]
            remotePath = lineSub.replace("Path :", "")
            break
    if remotePath == "":
        if lang == "zh":
            errMsg = u"获取日志收集文件失败。"
        else:
            errMsg = "Getting system log file failed."
        return (False, dataCollectRet, errMsg, deCompressDestDir)
    
    if not os.path.exists(dataCollectTmpDir):
        os.makedirs(dataCollectTmpDir)
        
    #指定文件名称为datacollect.tgz（避免文件名过长）
    localFile = dataCollectTmpDir + "datacollect.tgz"
    
    #步骤4：通过SFTP下载文件
    #通过sftp下载文件
    try:
        sftp.getFile(remotePath, localFile, None)
    except:
        #打印错误信息
        logger.error("catch except when download log file over!")
        logger.error("except trace back:" + unicode(traceback.format_exc()))
        if lang == "zh":
            errMsg = u"通过sftp下载文件失败，请联系技术支持工程师处理。"
        else:
            errMsg = "Failed to download files using SFTP. Contact technical support engineers."
        return (False, dataCollectRet, errMsg, deCompressDestDir)
    finally:
        #删除设备上临时文件
        sftp.deleteFile(remotePath)

    
    #步骤5：解压本地日志文件
    deCompressCmds = ['', '', 'OceanspaceS5000T']
    logger.info("It is going to decompress ******************************************************************************************************************")
    
    fileHandle = java_env.get("extraMap")
    deCompressDestDir = fileHandle.deCompressPackage(localFile, deCompressCmds)
    logger.info("Decompress datacollect file directory is: " + deCompressDestDir)
    
    #获取结果返回
    if not (os.path.exists(deCompressDestDir) and os.path.isdir(deCompressDestDir)):
        flag = False
        if lang == "zh":
            errMsg = u"获取一键收集日志结果文件失败。"
        else:
            errMsg = "Getting the datacollect result file failed."
    return (flag, dataCollectRet, errMsg, deCompressDestDir)
