﻿#coding: UTF-8

import re
from time import sleep
import checkSecure

#cli命令回文行数判断
G_CLI_INFO_NORMAL_ROW_MIN = 7

# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从Cli模式进入developer模式
# 输入参数:ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Developer(ssh, py_java_env):
    developerPwd = py_java_env.get("devPwd").get("developer")
    if not developerPwd:
        return False

    #判断是否为安全红线设备
    secureFlag = checkSecure.execute(ssh)
    if secureFlag:
        temp = ssh.execCmd("developer")
        
        #安全红线后设备进入developer模式
        if re.search("Are you sure", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("y")
            if re.search("Enter Password", temp1, re.IGNORECASE):
                temp2 = ssh.execCmdNoLog(developerPwd)
                if re.search("developer:", temp2, re.IGNORECASE):
                   return True
    else:
        temp = ssh.execCmd("developer")
        
        #安全红线前设备进入developer模式
        if re.search("Enter Password", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLog(developerPwd)
            if re.search("developer:", temp1, re.IGNORECASE):
                return True
        
    #进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False


# **************************************************************************** #
# 函数名称: changeCli2Developer
# 功能说明: 从Cli模式进入developer模式
# 输入参数:ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** #
def changeCli2DeveloperWithCliRet(ssh, py_java_env):
    cliRet = ''
    developerPwd = py_java_env.get("devPwd").get("developer")
    if not developerPwd:
        return False, cliRet

    # 判断是否为安全红线设备
    secureFlag = checkSecure.execute(ssh)
    if secureFlag:
        temp = ssh.execCmd("developer")
        cliRet += '\n' + temp

        # 安全红线后设备进入developer模式
        if re.search("Are you sure", temp, re.IGNORECASE):
            temp1 = ssh.execCmd("y")

            if re.search("Enter Password", temp1, re.IGNORECASE):
                temp2 = ssh.execCmdNoLog(developerPwd)
                if re.search("developer:", temp2, re.IGNORECASE):
                    return True, cliRet
    else:
        temp = ssh.execCmd("developer")
        cliRet += '\n' + temp
        # 安全红线前设备进入developer模式
        if re.search("Enter Password", temp, re.IGNORECASE):
            temp1 = ssh.execCmdNoLog(developerPwd)
            if re.search("developer:", temp1, re.IGNORECASE):
                return True, cliRet

    # 进入developer模式失败，重新回到CLI模式
    changeAnyModel2Cli(ssh)
    return False, cliRet

# **************************************************************************** #
# 函数名称: changeCli2Debug
# 功能说明: 从Cli到debug模式
# 输入参数:ssh
# 输出参数: 无
# 返 回 值: True or False
# **************************************************************************** # 
def changeCli2Debug(ssh, py_java_env):
    developerPwd = py_java_env.get("devPwd").get("developer")
    if not developerPwd:
        return False
    
    #判断是否为安全红线设备
    if checkSecure.execute(ssh):
        return False
    
    #安全红线前的设备：先进入developer
    if not changeCli2Developer(ssh, py_java_env):
        return False

    temp = ssh.execCmd("debug")
    #V1R2直接进入debug
    if re.search("Storage:", temp, re.IGNORECASE):
        return True
    #V1R1仍需要再多输入一次密码
    elif re.search("Enter Password", temp, re.IGNORECASE):
        temp1 = ssh.execCmdNoLog(developerPwd)
        if re.search("Storage:", temp1, re.IGNORECASE):
            return True
        else:
            changeAnyModel2Cli(ssh)
            return False
    #其他情况，返回失败
    else:
        changeAnyModel2Cli(ssh)
        return False

def changeAnyModel2Cli(ssh, sftp = None):
    '''
            1. 当从minisystem模式退到CLI模式时需要重连SFTP
            2. 修复当进入minisystem模式就断开连接的场景。
    '''
    counter = 0
    try:
        while True:
            # 修复当进入minisystem模式就断开连接的场景。当ssh断开时，直接就异常了。
            temp = ssh.execCmd("showsys")
            #非developer模式下，cli回文正确，则认为回到了cli
            if re.search("System Name", temp, re.IGNORECASE) \
                and not re.search("developer", temp, re.IGNORECASE):
                    break
            #老版本在minisystem下直接exit会退出连接，需要重连
            elif re.search("minisystem>", temp, re.IGNORECASE):
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    try:
                        ssh.execCmd("y")
                    except:
                        ssh.reConnect()
                        if sftp !=None:
                            sftp.reConnect()
                    continue

            #其他情况下，直接exit
            else:
                temp1 = ssh.execCmd("exit")
                if re.search("Are you sure", temp1, re.IGNORECASE):
                    ssh.execCmd("y")

            #单控的命令模式最多4层
            counter += 1
            if counter >= 4:
                break
    except:
        ssh.reConnect()
        if sftp != None:
            sftp.reConnect()
# **************************************************************************** #
# 函数名称: getPeerHeartBeatIP
# 功能说明: 解析数据，获取远端控制器的心跳IP
# 输入参数: 
# 输出参数:
# 返 回 值: 
# **************************************************************************** # 
def getPeerHeartBeatIP(heartBeatIPMsg):
    lines = heartBeatIPMsg.splitlines()
    for line in lines:
        peerHeartBeatIP = ''
        if 'inet addr:' in line:
            columnList = line.split()
            peerHeartBeatIP = columnList[1].split(':')[1]
        if '127.127.127.10' == peerHeartBeatIP:
            return '127.127.127.11'
        elif '127.127.127.11' == peerHeartBeatIP:
            return '127.127.127.10'
    return ''

# **************************************************************************** #
# 函数名称: linkCtrlByHeartBeat
# 功能说明: 通过心跳来切换命令发送的控制器   限Debug模式下使用
# 输入参数: dataDict
# 输出参数: NA
# 返 回 值: True,False
# **************************************************************************** # 
def linkCtrlByHeartBeat(cli):
    #执行此操作前确保切换到Storage命令模式
    heartBeatIPMsgOld = cli.execCmd('ifconfig bond0')
    peerHeartBeatIPOld = getPeerHeartBeatIP(heartBeatIPMsgOld)
    if not peerHeartBeatIPOld:
        return False
    
    cli.execCmd('ssh ibc_os_hs@' + peerHeartBeatIPOld)
    heartBeatIPMsgNew = cli.execCmd('ifconfig bond0')
    peerHeartBeatIPNew = getPeerHeartBeatIP(heartBeatIPMsgNew)
    
    if ('127.127.127' in peerHeartBeatIPOld 
        and '127.127.127' in peerHeartBeatIPNew
        and peerHeartBeatIPOld != peerHeartBeatIPNew):
        return True
    else:
        return False


def changeCliModel2Minisystem(ssh, py_java_env):
    '''
            函数名称: changeCliModel2Minisystem
            功能说明: 从CLI模式切换到minisystem模式
            输入参数: ssh, py_java_env, logger
            输出参数: 无
            返 回 值: True or False
    '''
    sftp = py_java_env.get("sftp")
    if not changeCli2Developer(ssh, py_java_env):
        changeAnyModel2Cli(ssh)
        return False
    checkRet = changeDeveloper2Minisystem(ssh, sftp)
    if not checkRet[0]:
        changeAnyModel2Cli(ssh)
        return False
    return True
def changeDeveloper2Minisystem(ssh, sftp = None):
    '''
            函数名称: changeDeveloper2Minisystem
            功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False，回文
    '''
    result1 = ""
    result = ssh.execCmdWithTimout("minisystem", 5)
    if re.search("minisystem>", result, re.IGNORECASE):
        return True,result
    if re.search("Are you sure", result, re.IGNORECASE):

        try:
            result1 = ssh.execCmd("y")
        except:
            ssh.reConnect()
            if sftp != None:
                sftp.reConnect()
            return False, ""
        if re.search("minisystem>", result1, re.IGNORECASE):
            return True, result + result1
    return False,""


def changeDeveloper2MinisystemWithCli(ssh, sftp = None):
    '''
            函数名称: changeDeveloper2Minisystem
            功能说明: 从developer模式进入minisystem模式（需要确定使用之前为developer模式）
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False，回文
    '''
    result1 = ""
    allCliRet = ''
    result = ssh.execCmdWithTimout("minisystem", 5)
    allCliRet += '\n' + result
    if re.search("minisystem>", result, re.IGNORECASE):
        return True,result

    if re.search("Are you sure", result, re.IGNORECASE):
        try:
            result1 = ssh.execCmd("y")
            allCliRet += '\n' + result1
        except:
            ssh.reConnect()
            if sftp != None:
                sftp.reConnect()
            return False, allCliRet
        if re.search("minisystem>", result1, re.IGNORECASE):
            return True, allCliRet
    return False, allCliRet

def linkCtrlInMinisystem(ssh, userPasswd):
    '''
            函数名称: linkCtrlInMinisystem
            功能说明: 从minisystemr模式对端控制器的CLI模式
            输入参数: ssh
            输入参数: userPasswd
            输入参数: ssh
            输出参数: 无
            返 回 值: True or False
    '''
    allRet = ""
    ret = ssh.execCmd("sshtoremote")
    allRet += ret
    if re.search("password", ret, re.IGNORECASE):
        ret = ssh.execCmdNoLogTimout(userPasswd, 5)
        if  re.search("admin:/>", ret, re.IGNORECASE):
            return True,allRet
    return False,allRet