﻿# -*- coding: UTF-8 -*-

import re
import xlrd
import os
import common
import compassCheck

G_LANG = "zh"

#P12V-2442 硬盘状态异常处理优化 modified 20130216 Begin
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 工具调用此方法执行风险盘检查
# 输入参数： ssh   工具与设备的ssh连接 
#        excelFilePath 需要解析的风险盘列表excel
# 输出参数: NA
# 返 回 值: （True/False:检查结果，cliRet：cli回显信息， checkDesc：检查详细信息） 
# 其 他   :  无
# **************************************************************************** # 
def execute(ssh, lang, excelFilePath):
    
    """初始化变量信息"""
    riskDiskList = []
    riskDiskCounter = 0
    cliRet = ''
    checkDesc = ''
    
    global G_LANG
    G_LANG = lang

    """工具取得风险盘的序列号list"""
    seriesNumList = compassCheck.getDiskList(excelFilePath)
    
    #P12V-2488 风险盘检查处理优化  added 20130225 Begin
    iRet = ssh.execCmd('chgpagination off')
    #P12V-2488 风险盘检查处理优化  added 20130225 End
    
    """查询硬盘的逻辑信息+物理信息"""
    allDiskPhyInfo = ssh.execCmd('showdisk -physic')
    allDiskLogInfo = ssh.execCmd('showdisk -logic')
    
    cliRet = allDiskPhyInfo + '\n' + allDiskLogInfo

    """判断cli回显信息"""
    if not re.search('Disk Information', allDiskPhyInfo, re.IGNORECASE):
        if lang == 'zh':
            checkDesc = u'\ncli回显信息错误'
        else:
            checkDesc = '\ncli information error'
        return (False, cliRet, checkDesc)
    
    allDiskPhyInfoList = allDiskPhyInfo.splitlines()
    if len(allDiskPhyInfoList) < 4:
        if lang == 'zh':
            checkDesc = u'\ncli回显信息错误'
        else:
            checkDesc = '\ncli information error'
        return (False, cliRet, checkDesc)
    
    if not re.search('Disk Information', allDiskLogInfo, re.IGNORECASE):
        if lang == 'zh':
            checkDesc = u'\ncli回显信息错误'
        else:
            checkDesc = '\ncli information error'
        return (False, cliRet, checkDesc)
    
    allDiskLogInfoList = allDiskLogInfo.splitlines()
    if len(allDiskLogInfoList) < 4:
        if lang == 'zh':
            checkDesc = u'\ncli回显信息错误'
        else:
            checkDesc = '\ncli information error'
        return (False, cliRet, checkDesc)

    #P11G-5853存在故障盘时列举出风险盘 modified 20130517 Begin    
    riskdiskPrint = ""
    """硬盘物理信息：检查指定盘是否在风险盘列表中"""
    for diskPhyInfo in allDiskPhyInfoList[6:]:
        
        field = diskPhyInfo.split()
        if len(field) < 8:
            continue
            
        diskLocation = field[0]

        iRet = compassCheck.getDiskPhysicDetailInfo(diskPhyInfo)
        diskSerialNum = iRet[1]
        fwVersion = iRet[2] #固件版本
        searchSerialNum = diskSerialNum[0:8]
        
        if (searchSerialNum in seriesNumList) and (fwVersion != 'B004'):            
            riskDiskList.append(diskLocation)
            riskDiskCounter += 1
            
            if riskDiskCounter == 1:
                riskdiskPrint += diskLocation
            else:     
                riskdiskPrint += ',' + diskLocation
            
    """判断所有盘物理状态：是否存在非Normal的盘"""
    iRet = compassCheck.checkPhysicDiskProcess(allDiskPhyInfoList, lang)
    if False == iRet[0]:
        checkDesc = iRet[1]
        
        #存在风险盘，则需要增加风险盘显示
        if riskDiskCounter != 0:
            if lang == 'zh':
                    checkDesc += u'\n同时，系统中存在需要修复的风险盘：' + riskdiskPrint + u'。'
            else:
                if riskDiskCounter == 1:    
                    checkDesc += u'\nMoreover, risk disk as follow:' + riskdiskPrint + '.'
                else:
                    checkDesc += u'\nMoreover, risk disks as follow:' + riskdiskPrint + '.'
                            
        return (False, cliRet, checkDesc)
            
    """判断所有盘逻辑状态：是否存在非Normal的盘"""
    iRet = compassCheck.checkLogicDiskProcess(allDiskLogInfoList, lang)
    if False == iRet[0]:
        checkDesc = iRet[1]
        
        #存在风险盘，则需要增加风险盘显示
        if riskDiskCounter != 0:
            if lang == 'zh':
                checkDesc += u'\n同时，系统中存在需要修复的风险盘：' + riskdiskPrint + u'。'
            else:
                if riskDiskCounter == 1:    
                    checkDesc += u'\nMoreover, risk disk as follow:' + riskdiskPrint + '.'
                else:
                    checkDesc += u'\nMoreover, risk disks as follow:' + riskdiskPrint + '.'   
                
        return (False, cliRet, checkDesc)
    #P11G-5853存在故障盘时列举出风险盘 modified 20130517 End

    """状态都正常，只有风险盘，则需要增加风险盘显示"""
    if riskDiskCounter != 0:
        if lang == 'zh':
            checkDesc += u'\n请按照指导书修复系统中存在的风险盘：' + riskdiskPrint + u'。'
        else:
            if riskDiskCounter == 1:    
                checkDesc += u'\nRepair the following compass disk in sequence according to the instructions in the guide:' + riskdiskPrint + '.'
            else:
                checkDesc += u'\nRepair the following compass disks in sequence according to the instructions in the guide:' + riskdiskPrint + '.'
                
        return (False, cliRet, checkDesc)
    else:
        if lang == 'zh':
            checkDesc = u'\n检查完成，不存在需要修复的风险盘。'
        else:
            checkDesc = '\nCompleted Checking, The storage system does not contain disk has a failure risk.'
        return (True, cliRet, checkDesc)
    

#P12V-2442 硬盘状态异常处理优化 modified 20130216 End
