# -*- coding: UTF-8 -*-
import os
import traceback
import cliCmd
import shutil
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil
from cbb.frame.util import public_ip_address_utils

def execute(devObj):
    try:
        #为每套设备创建文件存放文件夹
        tmpDataDir = devObj.get("tmpDataDir")
        devIp = py_java_env.get("devInfo").getIp()
        #ip用于创建目录
        devIp = str(devIp).replace(":",".")
        devSN = py_java_env.get("devInfo").getDeviceSerialNumber()
        
        localFileDir = tmpDataDir + os.path.sep + "data" + os.path.sep + "config" + os.path.sep + devIp + "_" + devSN
        if not os.path.exists(localFileDir):
            os.makedirs(localFileDir)
        
        #触发设备收集
        ssh = devObj.get("ssh")
        fileName = "config.txt"
        ipAddr = public_ip_address_utils.get_export_config_used_ip()
        strCmd = "exportconf -ip %s -u ftp_user -pwd ****** -f %s"%(ipAddr, fileName)
        cliRet = ssh.execCmdNoLogTimout(strCmd, 2*60)
        
        #下载文件
        sftp = devObj.get("sftp")
        serverPath = "/OSM/export_import/OSM_sysconfig.txt"
        runningDataName = "OSM_sysconfig.txt"
        sftp.getFile(str(serverPath),localFileDir,None)
        
        #对运行数据文件进行脱敏
        FileAnonymizeUtil.anonymizeWithEncoding(localFileDir, "utf-8")
        
        #删除文件
        sftp.deleteFile(serverPath)
        
        #修改本地配置文件名称
        oldName = unicode(localFileDir + os.path.sep + runningDataName)
        newName = unicode(localFileDir + os.path.sep + fileName)
        os.rename(oldName,newName)

        #收集clicmd文件(忽略异常)
        try:
            cliCmdFileDir = os.path.join(tmpDataDir, "data", "Other", devIp + "_" + devSN)
            #创建文件夹
            if not os.path.exists(cliCmdFileDir):
                os.makedirs(cliCmdFileDir)
            devObj["logger"] = PY_LOGGER
            cliCmd.collectCliCmd(devObj, cliCmdFileDir)
        except:
            PY_LOGGER.error("Failed to collect cliCmd:" + str(traceback.format_exc()))

        #删除由datacollect一键收集日志 命令  下载的本地文件 
        try:
            root = "pytemp" + os.sep
            if os.path.exists(root):
                shutil.rmtree(root)
        except:
            PY_LOGGER.error("Failed to delete dataCollect files:" + str(traceback.format_exc()))

        return ('', dict(flag = True, des = ""))
    except:
        PY_LOGGER.error("Failed to collect running file, because %s" % str(traceback.format_exc()))
        return ('', dict(flag=True, des =""))
        