# -*- coding: UTF-8 -*-
import traceback
import common
import re

#########################################
#      巡检前置脚本
# 巡检前检查设备是否正常，目前登录的用户模式
#########################################

#设置异常返回的提示信息，涉及到中英文

res_desc_zh = {'success': ur'系统检查通过', 
               'except':  ur'系统检查异常'
               }
                
res_desc_en = {'success': r'System check done',
               'except':  r'System check except'
               }
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 无
# 输出参数: True or False
# **************************************************************************** # 
def isChinese():
    lang = py_java_env.get("lang")
    if "zh"==lang:
        return True
    return False

# **************************************************************************** #
# 函数名称: isNormalSystem
# 功能说明: 判断系统状态是否正常
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def isNormalSystem(devObj):

    errMsg = ""
    ssh =  devObj.get("ssh")

    systemInfoStr = ssh.execCmd("showsys")
    #判断当前系统是否在升级中
    if re.search("upgrade:", systemInfoStr, re.IGNORECASE):
        if isChinese():
            errMsg = u"当前设备正在升级，不允许执行巡检工具。"
        else:
            errMsg = "Current system is in upgrading, can not perform the inspector."
        return (False, errMsg)
    
    #异常模式
    if re.search("-bash", systemInfoStr, re.IGNORECASE):
        if isChinese():
            errMsg = u"当前设备状态异常。"
        else:
            errMsg = "Current system is abnormal."
        return (False, errMsg)
        
    #查看回文信息是否有效（系统信息必须返回数据）
    checkFlag = common.checkCliInfoValid(systemInfoStr, True)
    if not checkFlag:
        if isChinese():
            errMsg = u"获取系统信息失败，请查看当前系统状态。"
        else:
            errMsg = "Getting system information failed, please confirm current system status."
        return (False, errMsg)
    
    #检查系统是否故障
    pattern = '\s*Current System Mode\s*\|(.*)'
    ret4Search = re.search(pattern, systemInfoStr, re.IGNORECASE)
    sysStatus = ''
    if ret4Search:
        sysStatus = ret4Search.group(1).strip()
    
    #系统状态异常
    if not sysStatus or ' Normal' not in sysStatus:
        if isChinese():
            errMsg = u"当前系统状态异常。"
        else:
            errMsg = "Current system is abnormal."
        return (False, errMsg)
    #检查通过
    return (True, '')
   
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 执行巡检脚本之前判断，判断系统是否处于正常状态
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def execute(devObj):
    try:
        lang = py_java_env.get("lang")
        #发送关闭分页功能的命令
        ssh =  devObj.get("ssh")
        ssh.execCmd("chgpagination off")
        #判断系统状态是否正常
        retMsg = isNormalSystem(devObj)
        #系统不正常
        if not retMsg[0]:
            return ('', dict(flag = False, des = retMsg[1]))
        #系统正常
        return ('', dict(flag = True, des = res_desc[lang]['success']))
    except:
        #系统异常
        return ('', dict(flag = False, des = res_desc[lang]['except']))
    