# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show enclosure"
        PY_LOGGER.info("Sequence[12] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[12] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        i = 0
        list = cliRet.splitlines()
        #巡检项检查结果优化 modified Begin
        for field in list:      
            list2 = field.split()
            if -1!=field.find("Expansion Enclosure") and len(list2)>5:
                if "--" == list2[len(list2)-1]:
                    continue
            
                temperature = int(list2[len(list2)-1])
                if temperature > 70:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n级联框["+list2[0]+u"]温度超过70摄氏度"
                    else:
                        errMsg += "\nThe temperature of expansion enclosure ["+list2[0]+"] exceed 70 celsius"
                    
        if not flag:
             PY_LOGGER.info("Sequence[12] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End
    except:
        PY_LOGGER.error("Sequence[12] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
