# -*- coding: UTF-8 -*-
import traceback
import common
import time
SLEEP_TIMES = 30
NEED_RETRY = False

# **************************************************************************** #
# 函数名称: checkFcPorts
# 功能说明: 判断FC端口是否巡检通过，由于是第一个涉及show port general命令的，因此不先
#           尝试通过接口从py_java_env中获取现成的showPortGeneral执行结果
# 输入参数: cli，lang
# 输出参数: True or False
# **************************************************************************** # 
def checkFcPorts(cli, lang):
    try:
        flag = True
        global NEED_RETRY
        chkfc_start = False
        NEED_RETRY = False
        cliRet = ""
        errMsg = ""


        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show port general"
        PY_LOGGER.info("Sequence[13] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[13] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End

        py_java_env.put("showPortGeneral", cliRet)

        list = cliRet.splitlines()
        #巡检项检查结果优化 modified Begin
        for field in list:
            if field.find("FC port") != -1:
                chkfc_start = True
            if field.find("SAS port") != -1 or field.find("COM port") != -1 or field.find("ETH port") != -1:
                chkfc_start = False
            if chkfc_start == True:
                #端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过
                checkLine = common.isNormalLine(field,lang)
                if not checkLine[0]:
                    flag = False
                    errMsg = checkLine[1]
                    return (flag, cliRet, errMsg)

                # 有效行数里面一定包括Host Port
                if -1 != field.find("Host Port"):
                    list2 = field.split()
                    if len(list2)<6:
                        continue

                        # 端口健康状态是否异常
                    if list2[1] != "Normal" :
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nFC端口["+list2[0]+u"]健康状态检查异常"
                        else:
                            errMsg += "\nThe linking FC port ["+list2[0]+"] health status is abnormal"

                    # 速率检查
                    if list2[1] == "Normal" and list2[3] == "Up":
                        #设备重启后立即巡检，规避FC速率还未协商上时巡检不通过的场景，2013/11/04 modified Begin
                        if -1 != list2[6].find("--") and flag:
                            flag = False
                            NEED_RETRY = True
                        #设备重启后立即巡检，规避FC速率还未协商上时巡检不通过的场景，2013/11/04 modified End

                        if list2[6] not in ["1000", "2000", "4000", "8000"]:
                            flag = False
                            if "zh" == lang:
                                errMsg += u"\nFC端口["+list2[0]+u"]速率异常"
                            else:
                                errMsg += "\nThe speed of FC port ["+list2[0]+"] is abnormal"

        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End


    except Exception, exception:
        PY_LOGGER.error("Sequence[13] catch except of trace back:" + str(traceback.print_exc()))
        NEED_RETRY = False
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy
    Return             : the checkitem is pass;cli source info
    """

    lang = py_java_env.get("lang")

    checkRet = checkFcPorts(cli, lang)

    #设备重启后立即巡检，规避FC速率还未协商上时巡检不通过的场景，2013/11/04 modified Begin
    if NEED_RETRY:
        time.sleep(SLEEP_TIMES)
        checkRet = checkFcPorts(cli, lang)

    if not checkRet[0]:
        PY_LOGGER.info("Sequence[13] inspect not pass.")
    return checkRet
    #设备重启后立即巡检，规避FC速率还未协商上时巡检不通过的场景，2013/11/04 modified End


