# -*- coding: UTF-8 -*-
import traceback
import common

UNCHECK_WORD = "EXP"
def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkSAS_start = False
        lang = py_java_env.get("lang")
        errMsg = ""
        listA = []
        listB = []
        CtrlA = False
        CtrlB = False
        listSpeedFault=[]
        dataDictInfo = {}
        
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show port general"
            PY_LOGGER.info("Sequence[14] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[14] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showPortGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[14] begin to inspect, get cli result form java.")
        
        list = cliRet.splitlines()
        for field in list:     
            if common.isEndLine(field):
                break  
            if field.find("SAS port") != -1:
                chkSAS_start = True
            if field.find("FC port") != -1 or field.find("COM port") != -1 \
                or field.find("ETH port") != -1 or field.find("FCoE port") != -1:
                chkSAS_start = False
            if chkSAS_start == True:
                #端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过
                checkLine = common.isNormalLine(field,lang)
                if not checkLine[0]:
                    flag = False
                    errMsg = checkLine[1]
                    return (flag, cliRet, errMsg)
                if field.find("Expansion Port") == -1:
                    continue
                list2 = field.split()
                if list2[1] != "Normal" :
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nSAS端口["+list2[0]+u"]健康状态检查异常"
                    else:
                        errMsg += "\nThe linking SAS port ["+list2[0]+"] health status is abnormal"
                if list2[1] == "Normal" and list2[3] == "Up":
                    if -1 != list2[0].find(".A") and -1 == list2[0].find(UNCHECK_WORD):
                        CtrlA = True
                        element = list2[0].replace(".A","")
                        dataDictInfo[list2[0]] = element
                        listA.append(element)
                    elif -1 != list2[0].find(".B") and -1 == list2[0].find(UNCHECK_WORD):
                        CtrlB = True
                        element = list2[0].replace(".B","")
                        dataDictInfo[list2[0]] = element
                        listB.append(element)
                    elif -1 == list2[0].find(".A") and -1 == list2[0].find(".B"):
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nSAS端口["+list2[0]+u"]名称检测异常"
                        else:
                            errMsg += "\nThe name ["+list2[0]+"] of linking SAS port is abnormal"
                    if -1 == field.find(" 6000 "):
                        listSpeedFault.append(list2[0])
      
        #巡检项处理优化  modified Begin
        #两端控制器状态不同的端口检查不通过
        allPortList = set(listA + listB)
        if CtrlA and CtrlB:    
            for port in allPortList:
                portId = ""
                if (port not in listA) or (port not in listB):
                    flag = False
                    for key in dataDictInfo:
                        if dataDictInfo[key] == port:
                            portId = key
                    if "zh" == lang:
                        if -1!=portId.find(".A"):
                            errMsg += u"\nSAS端口[" + portId.replace(".A", ".B") + u"]连接异常，与[" +portId+ u"]连接不对称"
                        else:
                             errMsg += u"\nSAS端口[" + portId.replace(".B", ".A") + u"]连接异常，与[" +portId+ u"]连接不对称"
                    else:
                        if -1!=portId.find(".A"):
                            errMsg += "\nThe linking SAS port [" + portId.replace(".A", ".B") + "] is abnormal, compare to ["+portId+"] is not symmetrical"
                        else:
                            errMsg += "\nThe linking SAS port [" + portId.replace(".B", ".A") + "] is abnormal, compare to ["+portId+"] is not symmetrical"

        for speedFault in listSpeedFault:
            flag = False
            if "zh" == lang:
                errMsg += u"\nSAS端口["+speedFault+u"]速率异常"
            else:
                errMsg += "\nThe speed of SAS port ["+speedFault+"] is abnormal"
        if not flag:
             PY_LOGGER.info("Sequence[14] inspect not pass.")
             
        return (flag, cliRet, errMsg)
        #巡检项处理优化  modified End
                                   
    except Exception, exception:
        PY_LOGGER.error("Sequence[14] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
