# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        chkmgt_start = False
        lang = py_java_env.get("lang")
    	errMsg = ""
        #Optimize check rate
        cliRet = "default"
        cliRet = py_java_env.get("showPortGeneral")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show port general"
            PY_LOGGER.info("Sequence[16] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[16] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showPortGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[16] begin to inspect, get cli result form java.")
        
        list = cliRet.splitlines()
        for field in list:     
            if field.find("Management Port:---") != -1:
                chkmgt_start = True
                
            #管理网口包含在ETH port中且是第一个出现，若是遇到其它关键字，直接退出判断循环
            if field.find("FC port:") != -1 or field.find("SAS port:") != -1 \
                or  field.find("COM port:") != -1 or field.find("FCoE port:") != -1\
                or field.find("Maintenance Port:---") != -1:
                break
                
            if chkmgt_start:
                #端口可能因为超时，socket连接失败等查询失败，此种情况直接返回不通过
                checkLine = common.isNormalLine(field,lang)
                if not checkLine[0]:
                    flag = False
                    errMsg = checkLine[1]
                    return (flag, cliRet, errMsg)
                
                if (-1!=field.find("Management Port") or -1!=field.find("Management/Host Port"))\
                    and -1==field.find("Management Port:---"):
                    list2 = field.split()
                    if len(list2)<3:
                        continue
                
                    #巡检项检查结果优化 modified Begin
                    if "Normal"!=list2[1] or "Up"!=list2[3]:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n管理网口["+list2[0]+u"]状态检查异常"
                        else:   
                            errMsg += "\nThe status of management port ["+list2[0]+"] is abnormal" 
                        continue
                 
                    if list2[-1] not in ["100","1000"]:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n管理网口["+list2[0]+u"]速率异常"
                        else:
                            errMsg += "\nThe speed of management port ["+list2[0]+"] is abnormal"
        
        if not flag:
             PY_LOGGER.info("Sequence[16] inspect not pass.")
                           
        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End
        
                            
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[16] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

