# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check software version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show version all"
            PY_LOGGER.info("Sequence[42] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[42] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showVersionAll", cliRet)
        else:
             PY_LOGGER.info("Sequence[42] begin to inspect, get cli result form java.")
                 
 
        list = cliRet.splitlines()
        ctlAVersion = ctlBVersion = "default"
        
        for field in list:
            field = field.replace(" ", "")         
            if (1 == field.startswith("SoftwareVersion:")) and ( ctlAVersion == "default"):
                ctlAVersion = field.replace("SoftwareVersion:", "")
            elif (1 == field.startswith("SoftwareVersion:")) and ( ctlBVersion == "default"):
                ctlBVersion = field.replace("SoftwareVersion:", "")
                break
            
        #Whether single or double controller, ctlAVersion must have version number.
        if "default" == ctlAVersion:
            flag = False
            PY_LOGGER.info("Sequence[42] inspect have null software version1, not pass.")
            if "zh" == lang:
                errMsg = u"\n控制器软件版本错误"
            else:
                errMsg = "\nThe software version of system is not correct"
            return (flag, cliRet, errMsg)

        #Double controller must have the same software version
        if ctlAVersion == ctlBVersion:
            flag = True
            return (flag, cliRet)
        
        #Single controller must have right software version number
        if (ctlAVersion != ctlBVersion) and ("default" == ctlBVersion):
            flag = True
            return (flag, cliRet)
        
        #Other condition
        flag = False
        PY_LOGGER.info("Sequence[42] inspect not pass.")
        if "zh" == lang:
            errMsg = u"\n系统软件版本错误"
        else:
            errMsg = "\nThe software versions of system is not correct"
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[42] catch except of check software version.")
        PY_LOGGER.error("Sequence[42] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[42] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[42] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
