# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check BMC version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show version all"
            PY_LOGGER.info("Sequence[43] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[43] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showVersionAll", cliRet)
        else:
             PY_LOGGER.info("Sequence[43] begin to inspect, get cli result form java.")
        
        list = cliRet.splitlines()
        ctlAVersion = ctlBVersion = "defaultBMC"
        
        for field in list:
            field = field.replace(" ", "")      
            if (1 == field.startswith("BMCVersion:")) and ( ctlAVersion == "defaultBMC"):
                ctlAVersion = field.replace("BMCVersion:", "")
            elif (1 == field.startswith("BMCVersion:")) and ( ctlBVersion == "defaultBMC"):
                ctlBVersion = field.replace("BMCVersion:", "")
                break

        #Whether single or double controller, ctlAVersion must have version number.
        if "defaultBMC" == ctlAVersion:
            flag = False
            PY_LOGGER.info("Sequence[43] inspect have null BMC version1, not pass.")
            if "zh" == lang:
                errMsg = u"\nBMC版本错误"
            else:
                errMsg = "\nThe version of BMC is not correct"
            return (flag, cliRet, errMsg)
        
        #Double controller must have the same software version
        if ctlAVersion == ctlBVersion:
            flag = True
            return (flag, cliRet)
        
        #Single controller must have right software version number
        if (ctlAVersion != ctlBVersion) and ("defaultBMC" == ctlBVersion):
            flag = True
            return (flag, cliRet)
        
        #Other condition
        flag = False
        PY_LOGGER.info("Sequence[43] inspect not pass.")
        if "zh" == lang:
            errMsg = u"\nBMC版本错误"
        else:
            errMsg = "\nThe version of BMC is not correct"
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[43] catch except of check BMC version.")
        PY_LOGGER.error("Sequence[43] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[43] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[43] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
