# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check SES version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show version all"
            PY_LOGGER.info("Sequence[44] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[44] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showVersionAll", cliRet)
        else:
             PY_LOGGER.info("Sequence[44] begin to inspect, get cli result form java.")

        #Check controller ses vesion
        list1 = cliRet.splitlines()
        ctlAVersion = ctlBVersion = "defaultSES"
        for field in list1:
            field = field.replace(" ", "")       
            if (1 == field.startswith("SESVersion:")) and ( ctlAVersion == "defaultSES"):
                ctlAVersion = field.replace("SESVersion:", "")
            elif (1 == field.startswith("SESVersion:")) and ( ctlBVersion == "defaultSES"):
                ctlBVersion = field.replace("SESVersion:", "")
                break
            
        if "defaultSES" == ctlAVersion: 
            PY_LOGGER.info("Sequence[44] inspect not pass, wrong version: "+ ctlAVersion+ " and "+ ctlBVersion)
            flag = False
            if "zh" == lang:
                errMsg = u"\n控制器SES版本不一致"
            else:
                errMsg = "\nThe controller SES have not the same version"
            return (flag, cliRet, errMsg)
        if (ctlAVersion == ctlBVersion) or ("defaultSES" == ctlBVersion):
            flag = True
        else:     
            PY_LOGGER.info("Sequence[44] inspect not pass, wrong version: "+ ctlAVersion+ " and "+ ctlBVersion)
            flag = False
            if "zh" == lang:
                errMsg = u"\n控制器SES版本不一致"
            else:
                errMsg = "\nThe controller SES is not the same version"
            return (flag, cliRet, errMsg)

        #Check enclosure ses vesion
        startFalg = False
        listA=[]
        listB=[]
        list2 = cliRet.splitlines()
        tempStr=""
        for line in list2:
            if line.startswith("Expansion Module:"):
                startFalg=True
                continue
            if line.startswith("BBU:"):
                break

            if startFalg:
                list = line.split()
                if len(list)<1:
                    continue

                if "ID"==list[0] or "--"==list[0]:
                    continue
                tempStr = str(line)
                if (-1!=list[0].find(".A")):
                    listA.append(tempStr[38:].replace(" ",""))
                if (-1!=list[0].find(".B")):
                    listB.append(tempStr[38:].replace(" ",""))
      
        for lineA in listA:
            if ""==lineA or " "==lineA or (-1!=lineA.find("-")):
                flag = False
               
        if flag:
            #single controller
            if ([]==listA and []!=listB) or ([]!=listA and []==listB):
                PY_LOGGER.info("Sequence[44] inspect single controller.")
                flag = True
            #double controller
            elif listA==listB:
                flag = True
            else:
                flag = False

        if flag == False:
            PY_LOGGER.info("Sequence[44] inspect not pass.")
            if "zh" == lang:
                errMsg = u"\n级联框SES版本不一致"
            else:
                errMsg = "\nThe enclosure SES is not the same version"
            return (flag, cliRet, errMsg)
    
        return (flag, cliRet, errMsg) 
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[44] catch except of check SES version.")
        PY_LOGGER.error("Sequence[44] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[44] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[44] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
