# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check BBU version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show version all"
            PY_LOGGER.info("Sequence[48] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[48] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showVersionAll", cliRet)
        else:
             PY_LOGGER.info("Sequence[48] begin to inspect, get cli result form java.")
             
        #Check BBU version
        list = cliRet.splitlines()
        startFalg = False
        wrongVersion = True
        bbuVesion=[]
        for field in list:     
            if field.startswith("BBU:"):
                startFalg = True

            if startFalg:
                listBBU = field.split()
                if common.isEndLine(field):
                    break
                
                if len(listBBU)<1 or -1 != field.find("BBU:") or -1 != field.find("Firmware") or \
                    (-1 != field.find("-----")) or (-1 != field.find(":/>")):
                    continue
                
                if len(listBBU)<2:
                    flag = False
                    wrongVersion = False
                    break  
                
                if -1 != listBBU[1].find("--"):
                    flag = False 
                    wrongVersion = False                       
                bbuVesion.append(listBBU[1])

        lenVesion = len(bbuVesion)
        
        if False == wrongVersion:
            flag = False
            if "zh" == lang:
                errMsg = u"\nBBU版本不正常"
            else:
                errMsg = "\nThe BBU is abnormal"
            return (flag, cliRet, errMsg)
        bbuVesion.sort()
            
        if 0==lenVesion:
            flag = False
            if "zh" == lang:
                errMsg = u"\nBBU个数不能为零"
            else:
                errMsg = "\nThe BBU number is wrong if equal to zero"
            return (flag, cliRet, errMsg)
        elif (bbuVesion[0]!=bbuVesion[lenVesion-1]):
            flag = False

        if flag == False:
            PY_LOGGER.info("Sequence[48] inspect not pass.")
            if "zh" == lang:
                errMsg = u"\nBBU版本不一致"
            else:
                errMsg = "\nThe BBU is not the same version"
            return (flag, cliRet, errMsg)
    
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[48] catch except of check BBU version.")
        PY_LOGGER.error("Sequence[48] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[48] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[48] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

