# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18 
    Function describe  : check SN
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
    	errMsg = ""
        cliRet = py_java_env.get("showSystemGeneral")
        if None == cliRet or "default" == cliRet:
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
            #执行的CLI命令
            cmd = "show system general"
            PY_LOGGER.info("Sequence[51] begin to inspect, exec cli command:"+str(cmd))
            #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
            checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
            cliRet = checkRet[1]
            errMsg = checkRet[2]
            if checkRet[0]:
                PY_LOGGER.info("Sequence[51] inspect not pass. (system abnormal!)")
                return (False, cliRet, errMsg)
            #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
            py_java_env.put("showSystemGeneral", cliRet)
        else:
             PY_LOGGER.info("Sequence[51] begin to inspect, get cli result form java.")
         
        #Find SN
        list = cliRet.splitlines()
        for field in list:
            field = field.replace(" ", "")         
            if (1 == field.startswith("SN:")):
                SN = field.replace("SN:", "")
                break

        #Judge the length
        if len("210235G6KDZ0B5000001") == len(SN):
            flag = True
        else :
            PY_LOGGER.info("Sequence[51] inspect SN is:"+SN + " Length is:" + str(len(SN)))
            PY_LOGGER.info("Sequence[51] inspect not pass.")
            if "zh" == lang:
                errMsg = u"\n设备序列号长度错误"
            else:
                errMsg = "\nThe length of device SN is not correct"
            return (flag, cliRet, errMsg)
        return (flag, cliRet)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[51] catch except ofcheck SN.")
        PY_LOGGER.error("Sequence[51] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[51] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[51] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
