# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function describe  : check LUN status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""
 
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show lun |filterRow Health\sStatus not equal_to Normal or Running\sStatus not equal_to Online"
        PY_LOGGER.info("Sequence[61] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[61] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet):
            return (True, cliRet)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
         
        list = cliRet.splitlines()
        
        #巡检项检查结果优化 modified 20130913 Begin
        for field in list:        
            line = field.strip()
            if line.startswith('show lun') or line.startswith('--') or len(line)== 0 or line.startswith('ID')\
            or len(line.split()) < 6:
                continue
            lunId = line.split()[0]
            flag = False
            if "zh" == lang:
                errMsg += u"\nLun[" + lunId + u"]状态检查异常"
            else:
                errMsg += "\nThe status of LUN [" + lunId + "] is abnormal"
                
        if not flag:
             PY_LOGGER.info("Sequence[61] inspect not pass.")
             
        return (flag, cliRet, errMsg) 
        #巡检项检查结果优化 modified 20130913 End
    except Exception, exception:
        PY_LOGGER.error("Sequence[61] catch except of check LUN status.")
        PY_LOGGER.error("Sequence[61] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[61] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[61] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
