# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check extent status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
        cliRet1 = ""
    	errMsg = ""

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show storage_pool general"
        PY_LOGGER.info("Sequence[65] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)
        cliRet1 = checkRet[1]
        errMsg = checkRet[2]
        if checkRet[0]:
            PY_LOGGER.info("Sequence[64] inspect not pass. (system abnormal!)")
            return (False, cliRet1, errMsg)
        
        #命令执行后包含Command executed successfully，直接退出，巡检通过
        if common.isExecSuccess(cliRet1):
            return (True, cliRet1)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        cliRet = ""
        list = cliRet1.splitlines()
        i = 0
        for field1 in list:
            i = i+1
            if i > 4:
                list1 = field1.split()

                #Find to the end
                if common.isEndLine(list1[0]):
                    break

                #Find right lines and show each POOL_ID
                if(len(list1) >= 6):
                    #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
                    cliRet2 = ""
                    PY_LOGGER.info("Sequence[65] show storage_pool tier ID is:"+ str(list1[0]))
                    #执行的CLI命令
                    cmd = "show storage_pool general "+ str(list1[0])
                    #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
                    checkRet =  common.isCliExecRetInBlackList(cli,cmd,lang,True)            
                    cliRet2 = checkRet[1]
                    cliRet = cliRet + cliRet2
                    errMsg += checkRet[2]
                    if checkRet[0]:
                        PY_LOGGER.info("Sequence[65] inspect not pass. (system abnormal!)")
                        return (False, cliRet1+cliRet, errMsg)
                    #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End

                    listTier = cliRet2.splitlines()
                    #Extent status equal to Ready, relocating and pause
                    for field2 in listTier:
                        extentStatus = "default"
                        field2 = field2.replace(" ", "")
                        #版本存在关键字为Relocation Status和Relocation Running Status的版本，同时兼容
                        if field2.startswith("RelocationStatus:") or field2.startswith("RelocationRunningStatus:"):
                            extentStatus = field2.replace("RelocationStatus:", "").replace("RelocationRunningStatus:", "")
                            if (extentStatus == "Ready") or (extentStatus == "Relocating") or (extentStatus == "Paused"):
                                PY_LOGGER.info("Sequence[65] check extent status is:" + str(extentStatus))
                                break
                            else:
                                flag = False
                                PY_LOGGER.info("Sequence[65] check extent status is wrong:" + str(extentStatus))
                                PY_LOGGER.info("\nSequence[65] inspect not pass.")
                                #巡检项检查结果优化 modified 20130913 Begin
                                if "zh" == lang:
                                    errMsg += u"\nPool["+list1[0]+u"]迁移状态检查异常"
                                else:
                                    errMsg += "\nThe relocation status of pool ["+list1[0]+"] is abnormal"
        if not flag:
             PY_LOGGER.info("Sequence[65] inspect not pass.")
             
        return(flag, cliRet1 + cliRet, errMsg)
        #巡检项检查结果优化 modified 20130913 End
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[65] catch except of check extent status.")
        PY_LOGGER.error("Sequence[65] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[65] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[65] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1 + cliRet, errMsg)
