# -*- coding: UTF-8 -*-
import traceback
import common
def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function describe  : check LUN controller
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet1 = ""
        cliRet2 = ""
    	errMsg = ""
        filterCmd1 = "show lun |filterRow Owner\sController equal_to A and Work\sController not equal_to A"
        filterCmd2 = "show lun |filterRow Owner\sController equal_to B and Work\sController not equal_to B"   
        
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        PY_LOGGER.info("Sequence[69] begin to inspect, exec cli command:"+str(filterCmd1))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,filterCmd1,lang,True)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        cliRet1 = checkRet[1]
        if checkRet[0]: 
            errMsg = checkRet[2]
            PY_LOGGER.info("Sequence[69] inspect not pass. (system abnormal!)")
        #命令执行后包含Command executed successfully，则不用进行后续的判断
        elif not common.isExecSuccess(cliRet1):      
            list = cliRet1.splitlines()
            i = 0
            #巡检项检查结果优化 modified Begin
            lunID = ""
            for field in list:
                i = i + 1
                #If more than 3 lines its means have not equal value
                if i > 3:
                    flag = False
                    if field.find("---") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    
                    if "zh" == lang:
                        errMsg += u"\nLun[" + lunID + u"]的工作控制器和归属控制器不一致"
                    else:
                        errMsg += "\nThe owner controller of lun [" + lunID + "] is not consistent with with work controller"

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        PY_LOGGER.info("Sequence[69] begin to inspect, exec cli command:"+str(filterCmd2))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.isCliExecRetInBlackList(cli,filterCmd2,lang,True)
        cliRet2 = checkRet[1]
        if checkRet[0]: 
            errMsg += checkRet[2]
            PY_LOGGER.info("Sequence[69] inspect not pass. (system abnormal!)")
            return (False, cliRet1, errMsg)
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        #命令执行后包含Command executed successfully，则不用进行后续的判断
        if not common.isExecSuccess(cliRet2):   
            list = cliRet2.splitlines()
            i = 0
            for field in list:
                i = i + 1
                #If more than 3 lines its means have not equal value
                if i > 3:
                    flag = False
                    if field.find("---") != -1:
                        continue
                    list2 = field.split()
                    if len(list2) < 3:
                        continue
                    lunID = list2[0]
                    
                    if "zh" == lang:
                        errMsg += u"\nLun[" + lunID + u"]的工作控制器和归属控制器不一致"
                    else:
                        errMsg += "\nThe owner controller of lun [" + lunID + "] is not consistent with work controller"

        if not flag:
             PY_LOGGER.info("Sequence[69] inspect not pass.")
             
        return (flag, cliRet1+cliRet2, errMsg)
        #巡检项检查结果优化 modified End
    except Exception, exception:
        PY_LOGGER.error("Sequence[69] catch except of check LUN controller.")
        PY_LOGGER.error("Sequence[69] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[69] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[69] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet1+cliRet2, errMsg)
